/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.util;

import com.avaya.panther.framework.puur.ConfigParamFileHandler;
import com.avaya.panther.framework.puur.PatchUpdateValidator;
import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.avaya.panther.panels.AvayaCustomDialog;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;

public class AvayaBaseUtil {
    public static void checkLockFile(AutomatedInstallData idata) {
        if (new File(idata.getInstallPath() + File.separator + "lock").exists()) {
            String msg = idata.langpack.getString("lockfile.exist");
            msg = msg + idata.getInstallPath();
            System.err.println(msg);
            Debug.error(msg);
            System.exit(-1);
        }
    }

    public static void loadVariablesFromConfigFile(AutomatedInstallData installData, String fileName) throws Exception {
        AvayaInstallerBase.loadCustomVariables(installData, fileName);
        if (!System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
            if (installData.getInstallPath() != null && installData.getInstallPath().contains(":")) {
                installData.setInstallPath(null);
            }
        } else if (installData.getInstallPath() != null && !installData.getInstallPath().contains(":")) {
            installData.setInstallPath(null);
        }
    }

    public static void initAvayaBase(AutomatedInstallData installdata, boolean doValidation) {
        Debug.log("Initializing Avaya Base with " + installdata.getInstallPath());
        AvayaBaseUtil.checkLockFile(installdata);
        if (AvayaInstallerBase.isUninstall()) {
            try {
                Debug.log("Loading config param file.");
                ConfigParamFileHandler.loadConfigParamFile(installdata);
            }
            catch (Exception e) {
                Debug.error("Loading of config param file failed - " + e.toString());
            }
            if (AvayaInstaller.panther.getResFileLoc() != null) {
                Debug.log("Loading response file.");
                try {
                    AvayaBaseUtil.loadVariablesFromConfigFile(installdata, AvayaInstaller.panther.getResFileLoc());
                    AvayaInstallerBase.setSpecialInstallVariables(installdata);
                }
                catch (Exception e) {
                    Debug.error("Loading of response file failed - " + e.toString());
                }
            }
        }
        AvayaBaseUtil.populateAvayaAvailablePacks(installdata);
        if (installdata.avayaAvailablePacks == null || installdata.avayaAvailablePacks.size() == 0) {
            Debug.error("Validation for all the available packs has failed.");
            String errMsg = installdata.langpack.getString("no.available.packs");
            if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
                AvayaCustomDialog avDlg = new AvayaCustomDialog(new JFrame(), true);
                avDlg.emitError(installdata.langpack.getString("installer.error"), errMsg);
            } else {
                System.out.println(errMsg);
            }
            System.exit(1);
        }
        AvayaBaseUtil.setPackVersionVariables(installdata);
        AvayaBaseUtil.setSelectedPack(installdata);
        AvayaBaseUtil.backupInventoryFile(installdata);
        AutomatedInstallData.doValidation = doValidation;
    }

    private static void populateAvayaAvailablePacks(AutomatedInstallData installdata) {
        if ("uninstall".equals(installdata.getVariable("INSTALLER_MODE"))) {
            return;
        }
        installdata.avayaAvailablePacks.clear();
        for (Pack pack : installdata.availablePacks) {
            installdata.avayaAvailablePacks.add(pack);
        }
        PatchUpdateValidator validator = new PatchUpdateValidator();
        if (installdata.info.getInstallType().equalsIgnoreCase("complete")) {
            validator.isNonPatchValid(installdata);
            validator.isUpdateUpgradeValid(installdata);
        } else {
            validator.isPatchValid(installdata);
        }
    }

    public static void setPackVersionVariables(AutomatedInstallData installData) {
        List list = installData.availablePacks;
        for (Pack pack : list) {
            String new_version_variable = pack.id + "_VERSION";
            String new_payload_version_variable = pack.id + "_PAYLOAD_VERSION";
            String prev_version_variable = pack.id + "_PREV_VERSION";
            String prev_payload_version_variable = pack.id + "_PREV_PAYLOAD_VERSION";
            String new_version = pack.getVersion().trim();
            Version objPrevVersion = InventoryUtil.getInventory().getLastInstalledVersion(pack.id, false);
            String prev_version = null;
            if (objPrevVersion != null) {
                prev_version = objPrevVersion.toString();
            }
            if (prev_version == null) {
                prev_version = new_version;
            }
            installData.setVariable(prev_version_variable, prev_version);
            installData.setVariable(new_version_variable, new_version);
            Version object_new_version = new Version(new_version);
            Version object_prev_version = new Version(prev_version);
            String payload_new_version = object_new_version.toString();
            String payload_prev_version = object_prev_version.toString();
            payload_new_version = payload_new_version.substring(0, payload_new_version.lastIndexOf("."));
            payload_prev_version = payload_prev_version.substring(0, payload_prev_version.lastIndexOf("."));
            installData.setVariable(prev_payload_version_variable, payload_prev_version);
            installData.setVariable(new_payload_version_variable, payload_new_version);
            Debug.log(new_version_variable + "=" + new_version);
            Debug.log(new_payload_version_variable + "=" + payload_new_version);
            Debug.log(prev_version_variable + "=" + prev_version);
            Debug.log(prev_payload_version_variable + "=" + payload_prev_version);
        }
    }

    private static void setSelectedPack(AutomatedInstallData installdata) {
        List avayaAvailablePacks = installdata.avayaAvailablePacks;
        if (avayaAvailablePacks != null && avayaAvailablePacks.size() == 0) {
            return;
        }
        if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
            installdata.selectedPacks.clear();
            for (Pack pack : avayaAvailablePacks) {
                if (!pack.preselected) continue;
                Debug.log("Adding " + pack.name + " in selected pack list.");
                installdata.selectedPacks.add(pack);
            }
        } else {
            Iterator selectedPackItr = installdata.selectedPacks.iterator();
            while (selectedPackItr.hasNext()) {
                Iterator availablePacksItr = avayaAvailablePacks.iterator();
                boolean found = false;
                Pack selectedPack = (Pack)selectedPackItr.next();
                while (availablePacksItr.hasNext()) {
                    Pack availablePack = (Pack)availablePacksItr.next();
                    if (!selectedPack.id.equals(availablePack.id)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Debug.log("Removing " + selectedPack.name + " from the selected pack list.");
                selectedPackItr.remove();
            }
        }
    }

    public static void backupInventoryFile(AutomatedInstallData installdata) {
        String installDataDir = installdata.getInstallPath() + File.separator + "installdata" + File.separator;
        Debug.log("Taking back up of inventory file.");
        File inventoryFile = new File(installDataDir + "inventory.xml");
        if (inventoryFile.exists()) {
            File inventoryBackup = new File(installDataDir + "inventory.xml.bak");
            if (inventoryBackup.exists()) {
                // empty if block
            }
            try {
                inventoryBackup.createNewFile();
                IoHelper.copyFile(inventoryFile, inventoryBackup);
            }
            catch (IOException e) {
                Debug.error("Unable to backup inventory file because of " + e.toString());
                ++AvayaInstallData.install_faliure_count;
                AvayaInstaller.panther.setInstallStatus("error");
            }
        } else {
            Debug.warn("Inventory file doesn't exist, unable to backup the inventory file.");
            ++AvayaInstallData.install_warnings_count;
            AvayaInstaller.panther.setInstallStatus("warning");
        }
    }
}

