/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.izforge.izpack.panels.ProcessingClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SimpleProcessingClient
implements ProcessingClient {
    private Map validatorParams;
    private String contents;
    private String separator;
    private List<String> inputFields = new ArrayList<String>();
    public static String errorMsg = "";

    public SimpleProcessingClient(String contents, Map validatorParams, String separator) {
        this.contents = contents;
        this.validatorParams = validatorParams;
        this.separator = separator;
        this.populateInputField();
    }

    private void populateInputField() {
        if (this.separator == null) {
            this.inputFields.add(this.contents);
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(this.contents, this.separator);
            while (st.hasMoreTokens()) {
                String fieldContent = st.nextToken();
                if (fieldContent == null || fieldContent.equals("")) continue;
                this.inputFields.add(fieldContent);
            }
        }
        catch (Exception ex) {
            this.inputFields.add(this.contents);
        }
    }

    public Map getValidatorParams() {
        if (this.validatorParams == null) {
            return new HashMap();
        }
        return this.validatorParams;
    }

    public String getFieldContents(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > this.inputFields.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("No Input Field available for index " + index);
        }
        return this.inputFields.get(index);
    }

    public int getNumFields() {
        return this.inputFields.size();
    }

    public String getText() {
        return this.contents;
    }

    public boolean hasParams() {
        return this.validatorParams != null && this.validatorParams.size() != 0;
    }

    public static String getErrorMsg() {
        return errorMsg;
    }

    public static void setErrorMsg(String errorMsg) {
        SimpleProcessingClient.errorMsg = errorMsg;
    }
}

