/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.izforge.izpack.gui.ButtonFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;

public class AvayaCustomDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel myPanel = new JPanel();
    private JPanel buttonPanel = null;
    private JButton yesButton = null;
    private JButton noButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JEditorPane jEditorPane = null;
    private JScrollPane jScrollPane = null;
    private boolean answer = false;
    private int questionsAnswer = 49;
    private int defaultAnswer = 49;

    public AvayaCustomDialog(JFrame frame, boolean modal) {
        super((Frame)frame, true);
        this.myPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setContentType("text");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setBackground(Color.WHITE);
        StyledEditorKit kit = new StyledEditorKit();
        this.jEditorPane.setEditorKit(kit);
        this.jEditorPane.setFont(frame.getFont());
        this.jEditorPane.getDocument().putProperty("__EndOfLine__", "\n");
        this.jScrollPane = new JScrollPane(this.jEditorPane);
        this.jScrollPane.setPreferredSize(new Dimension(250, 105));
        this.jScrollPane.setFont(frame.getFont());
        this.jScrollPane.setBackground(Color.WHITE);
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, 49);
    }

    public int askQuestion(String title, String question, int choices, int defaultAnswer) {
        this.showDialog(title, question, choices, defaultAnswer);
        return this.questionsAnswer;
    }

    public void emitNotification(String message) {
        this.showDialog("", message, 60, 70);
    }

    public boolean emitWarning(String title, String message) {
        this.showDialog(title, message, 61, 45);
        return this.answer;
    }

    public void emitError(String title, String message) {
        this.showDialog(title, message, 60, 70);
    }

    private void showDialog(String title, String question, int choices, int defaultAnswer) {
        this.setResizable(false);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(new Rectangle((int)(dim.getWidth() / 2.5), (int)(dim.getHeight() / 2.5), 300, 170));
        this.setTitle(title);
        this.questionsAnswer = this.defaultAnswer = defaultAnswer;
        this.jEditorPane.setText(question);
        this.myPanel.add(this.jScrollPane);
        this.buttonPanel.removeAll();
        if (choices == 37 || choices == 38) {
            this.yesButton = ButtonFactory.createButton("Yes", Color.BLACK);
            this.yesButton.addActionListener(this);
            this.buttonPanel.add(this.yesButton);
            this.noButton = ButtonFactory.createButton("No", Color.BLACK);
            this.noButton.addActionListener(this);
            this.buttonPanel.add(this.noButton);
        } else if (choices == 61 || choices == 60) {
            this.okButton = ButtonFactory.createButton("Ok", Color.BLACK);
            this.okButton.addActionListener(this);
            this.buttonPanel.add(this.okButton);
        }
        if (choices == 38 || choices == 61) {
            this.cancelButton = ButtonFactory.createButton("Cancel", Color.BLACK);
            this.cancelButton.addActionListener(this);
            this.buttonPanel.add(this.cancelButton);
        }
        this.add((Component)this.myPanel, "North");
        this.add((Component)this.buttonPanel, "South");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.yesButton != null && this.yesButton.getText() == ((JButton)e.getSource()).getText()) {
            this.questionsAnswer = 47;
            this.answer = true;
            this.setVisible(false);
        } else if (this.noButton != null && this.noButton.getText() == ((JButton)e.getSource()).getText()) {
            this.questionsAnswer = 49;
            this.answer = false;
            this.setVisible(false);
        } else if (this.okButton != null && this.okButton.getText() == ((JButton)e.getSource()).getText()) {
            this.questionsAnswer = 70;
            this.answer = true;
            this.setVisible(false);
        } else if (this.cancelButton != null && this.cancelButton.getText() == ((JButton)e.getSource()).getText()) {
            this.questionsAnswer = 45;
            this.answer = false;
            this.setVisible(false);
        } else {
            this.answer = false;
            this.questionsAnswer = this.defaultAnswer;
            this.setVisible(false);
        }
    }
}

