/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AvayaBuildHelpGUI {
    JFrame frame;

    public AvayaBuildHelpGUI(InstallData installdata, final LocaleDatabase langpack, String help_file) {
        this.frame = new JFrame(langpack.getString("installer.help"));
        URL url = null;
        JEditorPane editorPane = null;
        JButton okbutton = ButtonFactory.createButton(langpack.getString("installer.ok"), null, installdata.buttonsHColor);
        okbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(langpack.getString("installer.ok"))) {
                    AvayaBuildHelpGUI.this.frame.dispose();
                }
            }
        });
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        navPanel.add(Box.createHorizontalGlue());
        navPanel.add(okbutton);
        try {
            url = Installer.class.getClassLoader().getResource("res/" + help_file);
            editorPane = new JEditorPane(url);
        }
        catch (Exception ex) {
            editorPane = new JEditorPane("txt", langpack.getString("avaya.helpNotAvailable"));
            Debug.log("Help file not available:" + help_file);
        }
        Debug.log("Help file found:" + help_file);
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(editorPane);
        this.frame.getContentPane().add((Component)scrollPane, "Center");
        this.frame.getContentPane().add((Component)navPanel, "South");
        this.frame.pack();
        this.frame.setSize(installdata.guiPrefs.width, (int)((float)installdata.guiPrefs.height * 0.75f));
        this.frame.setResizable(installdata.guiPrefs.resizable);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        Dimension frameSize = this.frame.getSize();
        this.frame.setLocation(center.x - frameSize.width + frameSize.width / 4, center.y - frameSize.height + frameSize.width / 4);
    }

    public void show() {
        this.frame.setVisible(true);
    }
}

