/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.UserPathPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import net.n3.nanoxml.XMLElement;

public class AvUserPathInputPanelAutomationHelper
extends AvayaPanelAutomation {
    protected boolean _mustExist = false;
    protected String _error;
    protected String _warn;
    protected String _emptyTargetMsg;
    protected String _warnMsg;
    protected String _reqMsg;
    protected String _notValidMsg;
    protected String _notWritableMsg;
    protected String _createDirMsg;
    protected String _defaultDir = null;
    protected String _thisPanel = "UserPathInputPanel";
    protected String _defaultPanelName = "TargetPanel";
    protected String _targetPanel = "UserPathPanel";
    protected String _variableName = "pathVariable";
    protected String[] _existFiles = null;

    public boolean isValidated(AutomatedInstallData installData, XMLElement panelRoot) {
        String chosenPath = installData.getVariable(UserPathPanel.pathVariableName);
        if (null == chosenPath) {
            Debug.error("Error: User path is not specified");
            AvayaInstaller.panther.setPreInstallStatus("error");
            return false;
        }
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                Debug.error("Error: " + this._reqMsg);
                return false;
            }
            Debug.log(this._warn + ": " + this._emptyTargetMsg);
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        if (this.isMustExist()) {
            if (!path.exists()) {
                Debug.error("Error: " + this._reqMsg);
                return false;
            }
            if (!this.pathIsValid(installData)) {
                Debug.error("Error: " + this._notValidMsg);
                return false;
            }
        } else {
            if (!this.isWriteable(installData)) {
                Debug.error("Error: " + this._notWritableMsg);
                return false;
            }
            if (path.exists()) {
                Debug.log("User path " + path + " exists");
            } else {
                Debug.log("User path " + path + " will be created");
            }
        }
        return true;
    }

    public boolean isMustExist() {
        return this._mustExist;
    }

    public void setMustExist(boolean b) {
        this._mustExist = b;
    }

    protected boolean pathIsValid(AutomatedInstallData installData) {
        if (this._existFiles == null) {
            return true;
        }
        for (int i = 0; i < this._existFiles.length; ++i) {
            File path = new File(installData.getVariable(UserPathPanel.pathVariableName), this._existFiles[i]).getAbsoluteFile();
            if (path.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isWriteable(AutomatedInstallData installData) {
        File existParent = IoHelper.existingParent(new File(installData.getVariable(UserPathPanel.pathVariableName)));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }
}

