/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.panels.SimpleProcessingClient;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class AvUserInputPanelAutomationHelper
extends AvayaPanelAutomation {
    static int count = 0;
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_SEPARATOR = "separator";
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "userInputLang.xml";

    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        return this.isValidated(installData, panelRoot);
    }

    public boolean isValidated(AutomatedInstallData installData, XMLElement panelRoot) {
        XMLElement panelElement;
        String panelId = panelRoot.getAttribute("id");
        if (null == panelId) {
            return true;
        }
        try {
            panelElement = this.getPanelElement(panelId);
        }
        catch (Exception e) {
            Debug.trace(e);
            return true;
        }
        if (!installData.getRules().canShowPanel(panelId, new Properties())) {
            Debug.log("Can not show panel " + panelId);
            return true;
        }
        String condition = panelRoot.getAttribute("condition");
        if (condition != null && !installData.getRules().isConditionTrue(condition)) {
            Debug.log("Can not show panel " + panelId);
            return true;
        }
        Vector fieldElements = panelElement.getChildrenNamed("field");
        for (int i = 0; i < fieldElements.size(); ++i) {
            SimpleProcessingClient processingClient;
            boolean validationResult;
            Validator validator;
            XMLElement validatorElement;
            Vector forUnselectedPacks;
            boolean fieldFlag;
            XMLElement fieldElement = (XMLElement)fieldElements.elementAt(i);
            String fieldCondition = null;
            fieldCondition = fieldElement.getAttribute("conditionid");
            if (fieldCondition != null && !(fieldFlag = installData.getRules().isConditionTrue(fieldCondition)) || !this.itemRequiredForUnselected(forUnselectedPacks = fieldElement.getChildrenNamed("createForUnselectedPack"), installData)) continue;
            String variableAttribute = fieldElement.getAttribute("variable");
            if (fieldElement.getAttribute("type").equals("password") && fieldElement.getAttribute("confirmationid") != null && !fieldElement.getAttribute("confirmationid").equals("") || variableAttribute == null || (validatorElement = fieldElement.getFirstChildNamed("validator")) == null) continue;
            String validatorClass = validatorElement.getAttribute("class");
            try {
                validator = (Validator)Class.forName(validatorClass).newInstance();
            }
            catch (Exception e) {
                Debug.trace(e);
                continue;
            }
            String value = installData.getVariable(variableAttribute);
            if (value == null) {
                Debug.error("Value for " + variableAttribute + " is null");
                System.out.println("null value specified for variable: " + variableAttribute + " in the response file");
                AvayaInstaller.panther.setInstallStatus("error");
                return false;
            }
            HashMap<String, String> validatorParams = null;
            Vector paramElements = validatorElement.getChildrenNamed("param");
            if (paramElements != null && paramElements.size() > 0) {
                validatorParams = new HashMap<String, String>();
                for (XMLElement paramElement : paramElements) {
                    String paramName = paramElement.getAttribute("name");
                    String paramValue = paramElement.getAttribute("value");
                    validatorParams.put(paramName, paramValue);
                }
            }
            String separator = null;
            XMLElement specElement = fieldElement.getFirstChildNamed("spec");
            if (specElement != null) {
                String resultFormat = specElement.getAttribute(RULE_RESULT_FORMAT);
                if (resultFormat != null && resultFormat.equals(RULE_SPECIAL_SEPARATOR)) {
                    separator = specElement.getAttribute(RULE_SEPARATOR);
                } else if (resultFormat != null) {
                    Debug.error("FATAL::resultFormat other than specialSeparator is not supported, quitting the installation.");
                    AvayaInstaller.panther.setInstallStatus("error");
                    return false;
                }
            }
            if (validationResult = validator.validate(processingClient = new SimpleProcessingClient(value, validatorParams, separator))) continue;
            String validatorClassName = validatorClass;
            if (validatorClassName != null && Validator.validatorMap != null && Validator.validatorMap.containsKey(validatorClassName)) {
                if (!((Boolean)Validator.validatorMap.get(validatorClassName)).booleanValue()) {
                    return true;
                }
                AvayaInstaller.panther.setInstallStatus("error");
                Debug.error("Invalid value for variable: " + variableAttribute);
                return false;
            }
            AvayaInstaller.panther.setInstallStatus("error");
            Debug.error("Invalid value for variable: " + variableAttribute);
            System.out.println("Invalid/empty value for variable: " + variableAttribute + " in the response file");
            return false;
        }
        return true;
    }

    private XMLElement getPanelElement(String panelId) throws Exception {
        String specFileResourceName = ResourceManager.getInstance().getResourceBasePath() + "userInputSpec.xml";
        InputStream specStream = this.getClass().getResourceAsStream(specFileResourceName);
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setValidator(new NonValidator());
        parser.setReader(new StdXMLReader(specStream));
        XMLElement userInputSpecElement = (XMLElement)parser.parse();
        if (userInputSpecElement.hasChildren()) {
            Vector panelElements = userInputSpecElement.getChildrenNamed("panel");
            for (int i = 0; i < panelElements.size(); ++i) {
                XMLElement panelElement = (XMLElement)panelElements.elementAt(i);
                String panelIdFromAttribute = panelElement.getAttribute("id");
                if (panelIdFromAttribute == null || !panelId.equals(panelIdFromAttribute)) continue;
                return panelElement;
            }
        }
        throw new Exception("Panel with ID: " + panelId + " + not found.");
    }

    public void generatePropertyFile(Properties p, AutomatedInstallData installData) throws Exception {
        if (count == 0) {
            InputStream input = null;
            String resource = "userInputLang.xml_" + installData.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
            VariableSubstitutor vs = new VariableSubstitutor(installData.getVariables());
            input = ResourceManager.getInstance().getInputStream("userInputSpec.xml");
            if (input == null) {
                Debug.error("Spec file for UserInput panel does not exist");
                System.exit(1);
            }
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
            parser.setValidator(new NonValidator());
            parser.setReader(new StdXMLReader(input));
            XMLElement data = (XMLElement)parser.parse();
            if (data.hasChildren()) {
                Vector specElements = data.getChildrenNamed("panel");
                for (int i = 0; i < specElements.size(); ++i) {
                    String variable;
                    int j;
                    data = (XMLElement)specElements.elementAt(i);
                    Vector forUnselectedPacks = data.getChildrenNamed("createForUnselectedPack");
                    if (!this.itemRequiredForUnselected(forUnselectedPacks, installData)) continue;
                    String panelId = data.getAttribute("id");
                    boolean flag = false;
                    for (Object o : installData.panelsOrder) {
                        Panel panel = (Panel)o;
                        String panelCondition = null;
                        if (!panel.getPanelid().equals(panelId)) continue;
                        if (panel.hasCondition()) {
                            panelCondition = panel.getCondition();
                            flag = installData.getRules().isConditionTrue(panelCondition);
                            break;
                        }
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    Vector fields = data.getChildrenNamed("field");
                    for (j = 0; j < fields.size(); ++j) {
                        XMLElement element = (XMLElement)fields.elementAt(j);
                        variable = element.getAttribute("type");
                        if (variable == null || !variable.equals("title")) continue;
                        String title = element.getAttribute("txt");
                        String id = element.getAttribute("id");
                        if (id != null) {
                            title = this.langpack.getString(id);
                            title = vs.substitute(title, null);
                        }
                        if (title == null) continue;
                        String comment = "# " + title;
                        p.put(comment, (Object)null);
                    }
                    for (j = 0; j < fields.size(); ++j) {
                        String val;
                        boolean fieldFlag;
                        data = (XMLElement)fields.elementAt(j);
                        String fieldCondition = null;
                        fieldCondition = data.getAttribute("conditionid");
                        if (fieldCondition != null && !(fieldFlag = installData.getRules().isConditionTrue(fieldCondition)) || !this.itemRequiredForUnselected(forUnselectedPacks = data.getChildrenNamed("createForUnselectedPack"), installData) || data.getAttribute("type").equals("password") && data.getAttribute("confirmationid") != null && data.getAttribute("confirmationid") != "" || (variable = data.getAttribute("variable")) == null) continue;
                        String string = val = installData.getVariable(variable) == null ? "" : installData.getVariable(variable);
                        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                            val = val.replace(File.separator, "\\\\");
                        }
                        p.put(variable, val);
                    }
                }
            }
        }
        ++count;
    }

    private boolean itemRequiredForUnselected(Vector packs, AutomatedInstallData idata) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return false;
            }
        }
        return true;
    }
}

