/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.n3.nanoxml.XMLElement;

public class AvTreePacksPanelAutomationHelper
extends AvayaPanelAutomation {
    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        this.setVariables(installData);
        return true;
    }

    public void setVariables(AutomatedInstallData installData) {
        String packsList = installData.getVariable("packs");
        String packName = null;
        if (packsList != null) {
            StringTokenizer parser = new StringTokenizer(packsList, ",");
            installData.selectedPacks.clear();
            while (parser.hasMoreTokens()) {
                Iterator pack_it = installData.availablePacks.iterator();
                boolean found = false;
                String packId = parser.nextToken();
                while (!found && pack_it.hasNext()) {
                    Pack pack = (Pack)pack_it.next();
                    if (!pack.id.equals(packId)) continue;
                    installData.selectedPacks.add(pack);
                    this.addDependencyPacks(installData, pack);
                    found = true;
                }
                if (found) continue;
                String error = "Could not find selected pack named \"" + packName + "\" in line ";
                Debug.error(error);
            }
            Iterator iterator = installData.selectedPacks.iterator();
            while (iterator.hasNext()) {
                this.addDependencyPacks(installData, (Pack)iterator.next());
            }
        }
    }

    public long getTotalPackSize(AutomatedInstallData installData) {
        long totalPackSize = 0L;
        for (Pack pack : installData.selectedPacks) {
            totalPackSize += pack.nbytes;
        }
        return totalPackSize;
    }

    public long getFreeSpace(AutomatedInstallData installData) {
        long freeBytes = 0L;
        if (IoHelper.supported("getFreeSpace")) {
            freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(installData.getInstallPath())).getAbsolutePath());
        }
        return freeBytes;
    }

    public void addDependencyPacks(AutomatedInstallData installData, Pack pack) {
        List<Pack> list = AvayaInstallerBase.getDependencyPackList(installData, pack);
        if (null != list) {
            for (Pack dependencyPack : list) {
                if (installData.selectedPacks.contains(dependencyPack)) continue;
                installData.selectedPacks.add(dependencyPack);
                String info = "Pack " + dependencyPack.name + " is added as the pack " + pack.name + " depends on it.";
                Debug.log(info);
            }
        }
    }

    public void generatePropertyFile(Properties p, AutomatedInstallData installData) throws Exception {
        Iterator pack_it = installData.selectedPacks.iterator();
        StringBuffer packsList = new StringBuffer();
        while (pack_it.hasNext()) {
            packsList.append(((Pack)pack_it.next()).id);
            packsList.append(',');
        }
        if (packsList.length() >= 1) {
            packsList.deleteCharAt(packsList.length() - 1);
        }
        p.put("packs", packsList.toString());
    }

    public boolean isValidated(AutomatedInstallData idata) {
        if (idata.selectedPacks.isEmpty()) {
            Debug.error("Incorrect pack names specified in the input response file.Installation will be aborted.");
            System.out.println("Incorrect pack names specified in the input response file.Installation will be aborted.");
            return false;
        }
        System.out.println("\n\nChecking if the system has sufficient space as required by the selected packs.\n");
        System.out.println("Available Space: " + Pack.toByteUnitsString(this.getFreeSpace(idata)) + "\nTotal space Required: " + Pack.toByteUnitsString(this.getTotalPackSize(idata)) + "\n");
        Debug.log("Available Space: " + Pack.toByteUnitsString(this.getFreeSpace(idata)) + " Total space Required: " + Pack.toByteUnitsString(this.getTotalPackSize(idata)));
        if (this.getFreeSpace(idata) < this.getTotalPackSize(idata)) {
            System.out.println("Available space is less than the required space.");
            Debug.error("Available space is less than the required space.");
            return false;
        }
        return true;
    }
}

