/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.panels.AvPathInputPanelAutomationHelper;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import net.n3.nanoxml.XMLElement;

public class AvTargetPanelAutomationHelper
extends AvayaPanelAutomation {
    public void setVariables(AutomatedInstallData idata) {
    }

    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        this.setVariables(installData);
        return this.isValidated(installData, panelRoot);
    }

    public boolean isValidated(AutomatedInstallData installData, XMLElement panelRoot) {
        String installPath = installData.getInstallPath();
        if (installPath == null || installPath.trim().length() == 0) {
            AvayaInstaller.panther.setInstallStatus("error");
            Debug.error("Installation Path is empty.");
            return false;
        }
        AvPathInputPanelAutomationHelper pathPanelHelper = new AvPathInputPanelAutomationHelper();
        if (!pathPanelHelper.isValidated(installData, installData.getInstallPath())) {
            Debug.error("Incorrect Install Path: " + installData.getInstallPath());
            AvayaInstaller.panther.setInstallStatus("error");
            return false;
        }
        boolean writable = this.isWriteable(installPath);
        if (!writable) {
            AvayaInstaller.panther.setInstallStatus("error");
            return false;
        }
        return true;
    }

    public boolean isWriteable(String installPath) {
        File existParent = IoHelper.existingParent(new File(installPath));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public void generatePropertyFile(Properties p, AutomatedInstallData installData) throws Exception {
        p.put("# Installation Path Information", (Object)null);
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            p.put("INSTALL_PATH", installData.getInstallPath().replace(File.separator, "\\\\"));
        } else {
            p.put("INSTALL_PATH", installData.getInstallPath());
        }
    }
}

