/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.panels.AvPathInputPanelAutomationHelper;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import java.io.File;
import java.util.Properties;
import net.n3.nanoxml.XMLElement;

public class AvJDKPathPanelAutomationHelper
extends AvayaPanelAutomation {
    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        return this.isValidated(installData, panelRoot);
    }

    public void generatePropertyFile(Properties p, AutomatedInstallData installData) throws Exception {
        p.put("# JDK Path Information", (Object)null);
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            p.put("JDKPath", installData.getVariable("JDKPath").replace(File.separator, "\\\\"));
        } else {
            p.put("JDKPath", installData.getVariable("JDKPath"));
        }
    }

    public boolean isValidated(AutomatedInstallData installData, XMLElement panelRoot) {
        String[] output;
        boolean value;
        if (installData.getVariable("JDKPath") == null || installData.getVariable("JDKPath").trim().length() == 0) {
            AvayaInstaller.panther.setInstallStatus("error");
            Debug.error("JDK Path is empty.");
            return false;
        }
        AvPathInputPanelAutomationHelper pathPanelHelper = new AvPathInputPanelAutomationHelper();
        if (!pathPanelHelper.isValidated(installData, installData.getVariable("JDKPath"))) {
            Debug.error("Incorrect JDK Path: " + installData.getVariable("JDKPath"));
            AvayaInstaller.panther.setInstallStatus("error");
            return false;
        }
        FileExecutor fe = new FileExecutor();
        String[] params = new String[]{installData.getVariable("JDKPath") + File.separator + "bin" + File.separator + "java", "-version"};
        boolean bl = value = fe.executeCommand(params, output = new String[2]) == 0;
        if (!value) {
            Debug.error("Incorrect JDK Path: " + installData.getVariable("JDKPath"));
            AvayaInstaller.panther.setInstallStatus("error");
        }
        return value;
    }
}

