/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.uninstaller.Uninstaller;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.SwingUtilities;
import net.n3.nanoxml.XMLElement;

public class AvAvayaUninstallPanelAutomationHelper
extends AvayaPanelAutomation
implements AbstractUIProgressHandler {
    public AutomatedInstallData idata = null;
    private boolean rollback = false;
    private String packUninstallerURL = null;

    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        this.idata = installData;
        this.rollback = "rollback".equals(this.idata.getVariable("Uninstall"));
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    AvAvayaUninstallPanelAutomationHelper.this.runUninstaller();
                }
            });
        }
        catch (Exception e) {
            Debug.error(e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUninstaller() {
        URLClassLoader classLoader = null;
        Class<?> clazz = null;
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        ArrayList packs = (ArrayList)this.idata.selectedPacks;
        Pack packObj = null;
        for (Pack pack : packs) {
            HashMap<Pack, String> uninstallers = new HashMap<Pack, String>();
            String filePath = null;
            String packUninstallerDir = AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), null);
            packObj = new Pack(pack.name, pack.id, pack.getVersion(), pack.description, pack.osConstraints, pack.dependencies, pack.required, pack.preselected, pack.loose, null, pack.uninstall);
            if (this.rollback) {
                filePath = packUninstallerDir + File.separator + "uninstaller.jar";
                uninstallers.put(packObj, filePath);
            } else {
                int versionCount = 0;
                for (Version version : inventoryUtil.getPackVersions(pack.id)) {
                    if ("PATCH".toLowerCase().equals(inventoryUtil.getInstallType(version.toString()))) continue;
                    ++versionCount;
                    filePath = AvayaInstallerBase.generatePackMetadataPath(pack.id, version.toString(), null) + File.separator + "uninstaller.jar";
                    try {
                        packObj = (Pack)packObj.clone();
                        packObj.setVersion(version.toString());
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                    uninstallers.put(packObj, filePath);
                }
            }
            for (Pack currPack : uninstallers.keySet()) {
                File uninstallerFile = new File((String)uninstallers.get(currPack));
                if (!uninstallerFile.exists()) {
                    Debug.error("Uninstaller JAR not found.");
                    System.exit(-1);
                }
                try {
                    this.addURL(uninstallerFile.toURL());
                    this.packUninstallerURL = uninstallerFile.getAbsolutePath();
                    filePath = "jar:file://" + (String)uninstallers.get(currPack) + "!/";
                    URL url = new File(filePath).toURL();
                    classLoader = new URLClassLoader(new URL[]{url});
                    clazz = classLoader.loadClass("com.izforge.izpack.uninstaller.Uninstaller");
                    Uninstaller uninstaller = (Uninstaller)clazz.newInstance();
                    uninstaller.runUninstaller(currPack, this, this.rollback);
                }
                catch (Exception e) {
                    Debug.error(e);
                    e.printStackTrace();
                }
                finally {
                    if (this.rollback) {
                        IoHelper.deleteDir(packUninstallerDir);
                        continue;
                    }
                    IoHelper.deleteDir(this.idata.getInstallPath() + File.separator + "Uninstaller" + File.separator + currPack.id);
                }
            }
        }
        if (inventoryUtil.getInstalledPacks() != null && inventoryUtil.getInstalledPacks().size() == 0) {
            IoHelper.deleteDir(inventoryUtil.getInstallPath() + File.separator + "installdata");
            IoHelper.deleteDir(inventoryUtil.getInstallPath() + File.separator + "Uninstaller");
            File[] files = new File(inventoryUtil.getInstallPath()).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name != null && (name.contains(".installationinformation") || name.contains(".txt") || name.contains(".properties"));
                }
            });
            if (files != null) {
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    files[i].delete();
                }
            }
        }
        this.stopAction();
    }

    public void addURL(URL url) throws IOException {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = urlClassLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().equalsIgnoreCase(url.toString())) continue;
            Debug.log("URL " + url + " is already in the CLASSPATH");
            return;
        }
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (Throwable t) {
            Debug.error(t.getMessage());
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public void generatePropertyFile(Properties properties, AutomatedInstallData installData) throws Exception {
        properties.put("Uninstall", "rollback".equals(installData.getVariable("Uninstall")) ? "rollback" : "uninstall");
    }

    public void nextStep(String step_name, int step_no, int no_of_substeps) {
    }

    public void progress(int substep_no, String message) {
    }

    public void setSubStepNo(int no_of_substeps) {
    }

    public void startAction(String name, int no_of_steps) {
    }

    public void stopAction() {
    }

    public int askQuestion(String title, String question, int choices) {
        return 0;
    }

    public int askQuestion(String title, String question, int choices, int default_choice) {
        return 0;
    }

    public void emitError(String title, String message) {
    }

    public void emitNotification(String message) {
    }

    public boolean emitWarning(String title, String message) {
        return false;
    }

    public String getPackUninstallerURL() {
        return this.packUninstallerURL;
    }
}

