/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.panels;

import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Pack;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.installer.AutomatedInstallData;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import net.n3.nanoxml.XMLElement;

public class AvAvayaInventoryPanelAutomationHelper
extends AvayaPanelAutomation {
    public boolean runAutomated(AutomatedInstallData installData, XMLElement panelRoot) {
        this.setVariables(installData);
        return true;
    }

    public void setVariables(AutomatedInstallData installData) {
        String packsList = installData.getVariable("packs");
        boolean rollback = "rollback".equals(installData.getVariable("Uninstall"));
        String packId = null;
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        if (packsList != null) {
            StringTokenizer parser = new StringTokenizer(packsList, ",");
            installData.selectedPacks.clear();
            while (parser.hasMoreTokens()) {
                Iterator<Pack> packIterator = inventoryUtil.getInstalledPacks().iterator();
                boolean found = false;
                Version version = null;
                packId = parser.nextToken().trim();
                while (!found && packIterator.hasNext()) {
                    Pack pack = packIterator.next();
                    version = rollback ? inventoryUtil.getRollbackVersion(pack.getId()) : inventoryUtil.getLastInstalledVersion(pack.getId(), true);
                    if (version == null) continue;
                    com.izforge.izpack.Pack p = new com.izforge.izpack.Pack(pack.getName(), pack.getId(), version.toString(), "", null, null, true, true, false, "", true);
                    if (!pack.getId().equals(packId)) continue;
                    installData.selectedPacks.add(p);
                    found = true;
                }
            }
        }
    }

    public void generatePropertyFile(Properties properties, AutomatedInstallData installData) throws Exception {
        StringBuffer packsList = new StringBuffer();
        for (com.izforge.izpack.Pack pack : installData.selectedPacks) {
            packsList.append(pack.id);
            packsList.append(',');
        }
        if (packsList.length() >= 1) {
            packsList.deleteCharAt(packsList.length() - 1);
        }
        properties.put("packs", packsList.toString());
    }
}

