/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.inventory.spirit;

import com.avaya.panther.inventory.spirit.beans.Product;
import com.avaya.panther.inventory.spirit.beans.SupportedProducts;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SupportedProductsUtil {
    private File supportedProductsXmlFile;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private SupportedProducts supportedProducts;

    public SupportedProductsUtil(String supportedProductsFilePath) {
        try {
            JAXBContext context = JAXBContext.newInstance(SupportedProducts.class);
            this.marshaller = context.createMarshaller();
            this.unmarshaller = context.createUnmarshaller();
            this.supportedProductsXmlFile = new File(supportedProductsFilePath);
            this.supportedProducts = (SupportedProducts)this.unmarshaller.unmarshal(this.supportedProductsXmlFile);
        }
        catch (JAXBException e) {
            this.supportedProducts = new SupportedProducts();
        }
    }

    public void marshal() throws JAXBException, IOException {
        this.supportedProductsXmlFile.getParentFile().mkdirs();
        if (!this.supportedProductsXmlFile.isFile()) {
            this.supportedProductsXmlFile.createNewFile();
        }
        this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        this.marshaller.marshal((Object)this.supportedProducts, new FileOutputStream(this.supportedProductsXmlFile));
    }

    public Product getProduct(String managedElementId) {
        if (managedElementId == null || managedElementId.length() == 0) {
            throw new IllegalArgumentException("Invalid managedElementId: " + managedElementId);
        }
        List<Product> products = this.supportedProducts.getProduct();
        for (Product product : products) {
            if (!managedElementId.equals(product.getMgdElementId())) continue;
            return product;
        }
        Product product = new Product();
        product.setMgdElementId(managedElementId);
        this.supportedProducts.addProduct(product);
        return product;
    }

    public Product removeProduct(String managedElementId) {
        if (managedElementId == null || managedElementId.length() == 0) {
            throw new IllegalArgumentException("Invalid managedElementId: " + managedElementId);
        }
        List<Product> products = this.supportedProducts.getProduct();
        for (Product product : products) {
            if (!managedElementId.equals(product.getMgdElementId())) continue;
            this.supportedProducts.removeProduct(product);
            return product;
        }
        return null;
    }

    public static String parsePatch(String version) {
        if (version == null || version.trim().length() == 0) {
            return "";
        }
        int PATCH_ATTRIBUTE_INDEX = 3;
        String[] versionAttributes = version.split("\\.", 4);
        if (versionAttributes.length < 4) {
            return "";
        }
        return versionAttributes[3];
    }
}

