/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.inventory.spirit;

import com.avaya.panther.inventory.spirit.beans.AvayaInstalledProduct;
import com.avaya.panther.inventory.spirit.beans.AvayaInstalledSoftwareFeature;
import com.avaya.panther.inventory.spirit.beans.Root;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ProductInventoryUtil {
    public static final String DEFAULT_VENDOR_NAME = "Avaya";
    public static final String DEFAULT_STATUS = "Active";
    private File productsInventoryXmlFile;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Root root;

    public ProductInventoryUtil(String productsInventoryXmlFilePath) {
        try {
            JAXBContext context = JAXBContext.newInstance(Root.class);
            this.marshaller = context.createMarshaller();
            this.unmarshaller = context.createUnmarshaller();
            this.productsInventoryXmlFile = new File(productsInventoryXmlFilePath);
            this.root = (Root)this.unmarshaller.unmarshal(this.productsInventoryXmlFile);
        }
        catch (JAXBException e) {
            this.root = new Root();
        }
    }

    public AvayaInstalledProduct getAvayaInstalledProduct() {
        AvayaInstalledProduct product = this.root.getAvayaInstalledProduct();
        if (product == null) {
            product = new AvayaInstalledProduct();
            this.root.setAvayaInstalledProduct(product);
        }
        return product;
    }

    public AvayaInstalledSoftwareFeature getAvayaInstalledSoftwareFeature(String avayaInstalledSoftwareFeatureType) {
        if (avayaInstalledSoftwareFeatureType == null) {
            throw new NullPointerException("avayaInstalledSoftwareFeatureType is null.");
        }
        for (AvayaInstalledSoftwareFeature feature : this.root.getAvayaInstalledSoftwareFeature()) {
            if (!avayaInstalledSoftwareFeatureType.equals(feature.getAvayaInstalledSoftwareFeatureType())) continue;
            return feature;
        }
        AvayaInstalledSoftwareFeature feature = new AvayaInstalledSoftwareFeature();
        feature.setAvayaInstalledSoftwareFeatureType(avayaInstalledSoftwareFeatureType);
        this.root.addAvayaInstalledSoftwareFeature(feature);
        return feature;
    }

    public AvayaInstalledSoftwareFeature removeAvayaInstalledSoftwareFeature(String avayaInstalledSoftwareFeatureType) {
        if (avayaInstalledSoftwareFeatureType == null) {
            throw new NullPointerException("avayaInstalledSoftwareFeatureType is null.");
        }
        for (AvayaInstalledSoftwareFeature feature : this.root.getAvayaInstalledSoftwareFeature()) {
            if (!avayaInstalledSoftwareFeatureType.equals(feature.getAvayaInstalledSoftwareFeatureType())) continue;
            this.root.removeAvayaInstalledSoftwareFeature(feature);
            return feature;
        }
        return null;
    }

    public void marshal() throws IOException, JAXBException {
        this.productsInventoryXmlFile.getParentFile().mkdirs();
        if (!this.productsInventoryXmlFile.isFile()) {
            this.productsInventoryXmlFile.createNewFile();
        }
        this.marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        this.marshaller.marshal((Object)this.root, new FileOutputStream(this.productsInventoryXmlFile));
    }

    public static String formatInstalledDate(long millis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd hh:mm:ss");
        char[] formattedDateChars = dateFormat.format(new Date(millis)).toCharArray();
        if (formattedDateChars[4] == '0') {
            formattedDateChars[4] = 32;
        }
        return new String(formattedDateChars);
    }
}

