/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.inventory.listeners;

import com.avaya.panther.framework.puur.ConfigParamFileHandler;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.AvayaBaseInventory;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Pack;
import com.avaya.panther.inventory.beans.PatchVersion;
import com.avaya.panther.inventory.beans.TargetMachineDetails;
import com.avaya.panther.inventory.beans.Version;
import com.avaya.panther.util.AvayaBaseUtil;
import com.avaya.panther.util.OSValidator;
import com.avaya.panther.util.OsBitSize;
import com.avaya.panther.util.SPIRIT_HOME_Initialiser;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.panels.InstallPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBException;

public class AvayaInstallListener
extends SimpleInstallerListener {
    public void beforeInstallation(AutomatedInstallData idata) {
        OSValidator.validateOperatingSystem(idata);
        idata.setVariable("OS_BIT_SIZE", OsBitSize.getBitSize().toString());
        try {
            idata.setVariable("local_host_full_name", Inet4Address.getLocalHost().getHostName());
            idata.setVariable("local_host_ip_address", Inet4Address.getLocalHost().getHostAddress());
            if (Inet4Address.getLocalHost().getHostAddress() != null) {
                String peerId = Inet4Address.getLocalHost().getHostAddress();
                int index = 0;
                index = peerId.lastIndexOf(".");
                if (index > 0 && index + 1 <= peerId.length()) {
                    peerId = peerId.substring(index + 1, peerId.length());
                    idata.setVariable("jboss.messaging.ServerPeerID", peerId);
                }
            }
        }
        catch (Exception e) {
            Debug.error(e.toString());
        }
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        SPIRIT_HOME_Initialiser.Initialise_SPIRIT_HOME(idata);
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        IInventoryUtil inventory = InventoryUtil.getInventory();
        try {
            ArrayList<Pack> packList = new ArrayList<Pack>();
            Pack pack = null;
            ConfigParamFileHandler configParamHandler = new ConfigParamFileHandler();
            Properties variables = configParamHandler.setConfParamProperties(idata);
            if (idata.selectedPacks != null && idata.selectedPacks.size() > 0) {
                String fileName = idata.getInstallPath() + File.separator + "installdata";
                new File(fileName).mkdirs();
                fileName = fileName + File.separator + ".confParam";
                AvayaInstallerBase.generatePropertyFile(variables, fileName, true);
            }
            for (com.izforge.izpack.Pack selectedPack : (ArrayList)idata.selectedPacks) {
                ArrayList<Version> versionList = new ArrayList<Version>();
                ArrayList<PatchVersion> patchVersionList = new ArrayList<PatchVersion>();
                if (AvayaInstallerBase.getVersionType(selectedPack.getVersion()).equals("PATCH")) {
                    String requiredVersions = null;
                    if (!idata.info.isCumulative()) {
                        for (String reqdVersion : selectedPack.getRequiredVersions()) {
                            if (reqdVersion == null) continue;
                            if (requiredVersions == null) {
                                requiredVersions = reqdVersion;
                                continue;
                            }
                            requiredVersions = requiredVersions + "," + reqdVersion;
                        }
                    }
                    patchVersionList.add(new PatchVersion(selectedPack.getVersion(), requiredVersions));
                } else {
                    versionList.add(new Version(selectedPack.getVersion()));
                }
                pack = new Pack(selectedPack.id, selectedPack.getName(), versionList, patchVersionList);
                packList.add(pack);
                inventory.addPack(pack, new TargetMachineDetails(idata.getVariable("local_host_full_name"), idata.getVariable("local_host_ip_address"), idata.getInstallPath()));
                if ("Panther".equalsIgnoreCase(selectedPack.id)) continue;
            }
            if (AvayaInstaller.panther.isAllowAvayaBaseDefinition()) {
                AvayaBaseInventory avayaBaseInventory = null;
                avayaBaseInventory = OsVersion.IS_WINDOWS ? new AvayaBaseInventory(AvayaBaseInventory.Os.WINDOWS) : new AvayaBaseInventory(AvayaBaseInventory.Os.UNIX);
                avayaBaseInventory.addAvayaBase(idata.getInstallPath());
            }
            InputStream inputStream = AvayaInstallListener.class.getResourceAsStream("/res/Avaya.uninstaller");
            String uninstallerPath = idata.getVariable("INSTALL_PATH") + File.separator + "Uninstaller";
            File uninstallWrapper = new File(uninstallerPath + File.separator + "uninstaller.jar");
            if (uninstallWrapper.exists()) {
                IoHelper.deleteFile(uninstallWrapper);
            }
            File uninstallerDir = new File(uninstallerPath);
            boolean uninstallerCreated = uninstallerDir.mkdirs();
            Debug.log("Uninstaller created successfully at location: " + uninstallerPath);
            int totalCount = 0;
            ZipInputStream zipStream = new ZipInputStream(AvayaInstallListener.class.getResourceAsStream("/res/Avaya.uninstaller"));
            while (zipStream.getNextEntry() != null) {
                zipStream.closeEntry();
                ++totalCount;
            }
            if (handler instanceof InstallPanel) {
                ((InstallPanel)handler).startPutUninstaller("Creating uninstaller wrapper");
                ((InstallPanel)handler).getOverallProgressBar().setMaximum(totalCount);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(uninstallerPath + File.separator + idata.info.getUninstallerName());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            int count = 0;
            while (zipEntry != null) {
                zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                int uninstallData = zipInputStream.read();
                while (uninstallData != -1) {
                    zipOutputStream.write(uninstallData);
                    uninstallData = zipInputStream.read();
                }
                if (handler instanceof InstallPanel) {
                    ((InstallPanel)handler).uninstallerProgress(++count, totalCount);
                }
                zipInputStream.closeEntry();
                zipOutputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            zipOutputStream.close();
            bufferedOutputStream.close();
            fileOutputStream.close();
            File unInstallerScriptFileName = new File(uninstallerPath + File.separator + "runUninstaller" + (System.getProperty("os.name").indexOf("Windows") > -1 ? ".bat" : ".sh"));
            FileOutputStream outputStream = new FileOutputStream(unInstallerScriptFileName);
            BufferedOutputStream stream = new BufferedOutputStream(outputStream);
            String path = System.getProperty("os.name").indexOf("Windows") > -1 ? "/res/Avaya.uninstallerbatch" : "/res/Avaya.uninstallerscript";
            InputStream batchStream = UnpackerBase.class.getResourceAsStream(path);
            int text = 0;
            byte[] buff = new byte[1024];
            while ((text = batchStream.read(buff, 0, 1024)) > -1) {
                stream.write(buff, 0, text);
            }
            stream.flush();
            stream.close();
            outputStream.flush();
            outputStream.close();
            String unInstallerScriptFilePath = unInstallerScriptFileName.getAbsolutePath();
            if (unInstallerScriptFilePath.endsWith(".sh")) {
                String[] execBitCommandForUninstallerScript = new String[]{"/bin/chmod", "a+x", unInstallerScriptFilePath};
                Debug.trace("Setting exec bit to: " + unInstallerScriptFileName);
                FileExecutor.getExecOutput(execBitCommandForUninstallerScript);
            }
            AvayaBaseUtil.backupInventoryFile(idata);
            IoHelper.deleteFile(idata.getInstallPath() + File.separator + "lock");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

