/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.inventory;

import com.avaya.panther.inventory.AIFInventory;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.beans.AvayaInstallInventory;
import com.avaya.panther.inventory.beans.Pack;
import com.avaya.panther.inventory.beans.PatchVersion;
import com.avaya.panther.inventory.beans.TargetMachineDetails;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.installer.AutomatedInstallData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InventoryUtil
implements IInventoryUtil {
    private static final String INVENTORY_XML = "/inventory.xml";
    private static IInventoryUtil inventoryUtil = null;
    private static AIFInventory inventory = null;
    private static AvayaInstallInventory avayaInstallInventory = null;
    private static JAXBContext context = null;
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;
    private static String inventoryFileLocation = null;
    public static boolean isInited = false;

    private InventoryUtil() {
    }

    public static synchronized AIFInventory getInventory(String installPath) {
        if (inventory == null) {
            InventoryUtil.init(installPath);
            inventory = new InventoryUtil();
        }
        return inventory;
    }

    public static synchronized IInventoryUtil getInventory() {
        if (inventoryUtil == null || !isInited) {
            InventoryUtil.init(new String[0]);
            inventoryUtil = new InventoryUtil();
        }
        return inventoryUtil;
    }

    private static void init(String ... installPath) {
        try {
            context = JAXBContext.newInstance(AvayaInstallInventory.class);
            AutomatedInstallData idata = AutomatedInstallData.getInstance();
            if ((idata == null || idata.getInstallPath() == null || idata.getInstallPath().equals("")) && installPath == null && installPath.length == 0) {
                System.out.println("ERROR:::Install path is empty, initialization of inventory failed !!!");
                System.exit(-1);
            }
            marshaller = context.createMarshaller();
            unmarshaller = context.createUnmarshaller();
            String invFilePath = null;
            if (idata != null && idata.getInstallPath() != null) {
                invFilePath = idata.getInstallPath() + File.separator + "installdata";
            } else if (installPath != null && installPath.length > 0) {
                invFilePath = installPath[0] + File.separator + "installdata";
            }
            File inventoryDir = new File(invFilePath);
            inventoryDir.mkdirs();
            inventoryFileLocation = invFilePath + INVENTORY_XML;
            if (inventoryFileLocation != null && inventoryFileLocation.contains("%20")) {
                inventoryFileLocation = inventoryFileLocation.replace("%20", " ");
            }
            avayaInstallInventory = new File(inventoryFileLocation).exists() ? (AvayaInstallInventory)InventoryUtil.unmarshall() : new AvayaInstallInventory();
            isInited = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object unmarshall() throws JAXBException {
        return unmarshaller.unmarshal(new File(inventoryFileLocation));
    }

    private static void marshall(Object object) throws JAXBException, FileNotFoundException {
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(object, new FileOutputStream(new File(inventoryFileLocation)));
    }

    @Override
    public List<Pack> getInstalledPacks() {
        return InventoryUtil.avayaInstallInventory.packs;
    }

    @Override
    public List<String> getInstalledPackIDs() {
        ArrayList<String> packIDs = null;
        if (avayaInstallInventory != null && InventoryUtil.avayaInstallInventory.packs != null) {
            packIDs = new ArrayList<String>();
            for (Pack pack : InventoryUtil.avayaInstallInventory.packs) {
                packIDs.add(pack.getId());
            }
        }
        return packIDs;
    }

    @Override
    public String getInstallPath() {
        return InventoryUtil.avayaInstallInventory.targetMachineDetails != null ? InventoryUtil.avayaInstallInventory.targetMachineDetails.getInstallPath() : null;
    }

    @Override
    public boolean isPackInstalled(String packId) {
        List<Pack> packList = this.getInstalledPacks();
        if (packList != null) {
            for (Pack pack : packList) {
                if (!pack.getId().equals(packId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Pack getPack(String packId) {
        if (InventoryUtil.avayaInstallInventory.packs != null) {
            for (Pack pack : InventoryUtil.avayaInstallInventory.packs) {
                if (!pack.getId().equals(packId)) continue;
                return pack;
            }
        }
        return null;
    }

    @Override
    public void addPack(Pack pack, TargetMachineDetails targetMachineDetails) throws JAXBException, FileNotFoundException {
        if (InventoryUtil.avayaInstallInventory.packs == null || InventoryUtil.avayaInstallInventory.packs.size() <= 0) {
            InventoryUtil.avayaInstallInventory.packs = new ArrayList<Pack>();
        }
        InventoryUtil.avayaInstallInventory.targetMachineDetails = targetMachineDetails;
        int packIndex = -1;
        packIndex = InventoryUtil.avayaInstallInventory.packs.indexOf(pack);
        if (packIndex >= 0) {
            this.updatePack(pack, packIndex);
        } else {
            InventoryUtil.avayaInstallInventory.packs.add(pack);
            InventoryUtil.marshall(avayaInstallInventory);
        }
    }

    private void updatePack(Pack pack, int packIndex) throws JAXBException, FileNotFoundException {
        Pack mPack = InventoryUtil.avayaInstallInventory.packs.get(packIndex);
        mPack.updatePack(pack.getId(), pack.getName(), pack.getVersion(), pack.getPatchversion());
        InventoryUtil.marshall(avayaInstallInventory);
    }

    @Override
    public void removePacks(List<Pack> packList) throws JAXBException, FileNotFoundException {
        InventoryUtil.avayaInstallInventory.packs.removeAll(packList);
        InventoryUtil.marshall(avayaInstallInventory);
    }

    @Override
    public void removePackVersion(String packId, List<Version> versionList) throws JAXBException, FileNotFoundException {
        List<Pack> packList = InventoryUtil.avayaInstallInventory.packs;
        if (packList != null) {
            for (Pack pack : packList) {
                if (!pack.getId().equals(packId) || pack.getVersion() == null) continue;
                pack.getVersion().removeAll(versionList);
                if (pack.getVersion().size() == 0) {
                    InventoryUtil.avayaInstallInventory.packs.remove(pack);
                }
                InventoryUtil.marshall(avayaInstallInventory);
                break;
            }
        }
    }

    @Override
    public void removePatchVersion(String packId, List<Version> patchVersionList) throws JAXBException, FileNotFoundException {
        List<Pack> packList = InventoryUtil.avayaInstallInventory.packs;
        if (packList != null) {
            for (Pack pack : packList) {
                if (!pack.getId().equals(packId) || pack.getPatchversion() == null) continue;
                pack.getPatchversion().removeAll(patchVersionList);
                InventoryUtil.marshall(avayaInstallInventory);
                break;
            }
        }
    }

    @Override
    public Version getLastInstalledVersion(String packId, boolean newInstallVersionOnly) {
        List<Pack> packList = avayaInstallInventory.getPack();
        if (packList != null) {
            for (Pack pack : packList) {
                if (!pack.getId().equals(packId)) continue;
                List<Version> versionList = pack.getVersion();
                List<PatchVersion> patchVersionList = pack.getPatchversion();
                String versionId = "";
                String patchVersionId = "";
                if (versionList != null && versionList.size() > 0) {
                    versionId = versionList.get(0).getId();
                }
                if ((versionList == null || versionId == null) && newInstallVersionOnly) {
                    return null;
                }
                if (newInstallVersionOnly) {
                    return new Version(versionId);
                }
                if (patchVersionList != null && patchVersionList.size() > 0) {
                    patchVersionId = patchVersionList.get(0).getId();
                }
                if (versionId.equals("") && patchVersionId.equals("")) {
                    return null;
                }
                if (patchVersionId.equals("")) {
                    return new Version(versionId);
                }
                if (versionId.equals("")) {
                    return new Version(patchVersionId);
                }
                int returnVal = this.getMaxVersion(new Version(versionId), new Version(patchVersionId));
                if (returnVal >= 0) {
                    return new Version(versionId);
                }
                return new Version(patchVersionId);
            }
        }
        return null;
    }

    @Override
    public int getMaxVersion(Version version1, Version version2) {
        return version1.compareTo(version2);
    }

    @Override
    public List<String> getRequiredVersionsList(Pack pack, Version patchVersion) {
        List<PatchVersion> patchVersionList = pack.getPatchversion();
        int index = -1;
        index = patchVersionList.indexOf(patchVersion);
        if (index > -1) {
            PatchVersion pv = patchVersionList.get(index);
            return pv.getRequiredVersion();
        }
        return null;
    }

    @Override
    public boolean versionExists(String packId, Version version) {
        List<Pack> packList = this.getInstalledPacks();
        if (packList == null || packList.size() == 0) {
            return false;
        }
        for (Pack pack : packList) {
            if (!packId.equals(pack.getId())) continue;
            if (pack.getVersion() != null && pack.getVersion().contains(version)) {
                return true;
            }
            if (pack.getPatchversion() == null || !pack.getPatchversion().contains(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Version> getPackVersions(String packID) {
        List<Pack> packList = avayaInstallInventory.getPack();
        List<Version> versionList = new ArrayList<Version>();
        if (packList != null) {
            for (Pack pack : packList) {
                if (!pack.getId().equals(packID)) continue;
                versionList = pack.getVersion();
                if (pack.getPatchversion() == null || pack.getPatchversion().size() <= 0) continue;
                versionList.addAll(pack.getPatchversion());
            }
        }
        return versionList;
    }

    @Override
    public Version getRollbackVersion(String packId) {
        List<Pack> allPacks = InventoryUtil.avayaInstallInventory.packs;
        if (allPacks == null || allPacks.size() == 0) {
            return null;
        }
        for (Pack pack : allPacks) {
            if (!pack.getId().equals(packId)) continue;
            List<Version> versionList = pack.getVersion();
            List<PatchVersion> patchVersionList = pack.getPatchversion();
            if (versionList == null || versionList.size() == 0) {
                return null;
            }
            if (versionList.size() == 1 && (patchVersionList == null || patchVersionList.size() == 0)) {
                return null;
            }
            return this.getLastInstalledVersion(packId, false);
        }
        return null;
    }

    @Override
    public String getInstallType(String version) {
        Version versionObj = new Version(version);
        version = versionObj.toString();
        String[] versionArr = version.split("\\.");
        int i = 0;
        for (i = 3; i > -1 && versionArr[i].equals("0"); --i) {
        }
        switch (i) {
            case 0: {
                return "new";
            }
            case 1: {
                return "upgrade";
            }
            case 2: {
                return "update";
            }
            case 3: {
                return "patch";
            }
        }
        return "new";
    }

    @Override
    public String getPackName(String packID) {
        if (InventoryUtil.avayaInstallInventory.packs != null) {
            for (Pack pack : InventoryUtil.avayaInstallInventory.packs) {
                if (!pack.getId().equals(packID)) continue;
                return pack.getName();
            }
        }
        return null;
    }

    @Override
    public TargetMachineDetails getTargetMachineDetails() {
        return avayaInstallInventory.getTargetMachineDetails();
    }
}

