/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.inventory;

import com.coi.tools.os.izpack.Registry;
import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AvayaBaseInventory {
    private static final String MS_WIN_AIF_AVAYA_BASE_REG_VAL = "AvayaBase";
    private static final String MS_WIN_AIF_REG_KEY = "SOFTWARE\\Avaya\\AIF";
    private static final String UNIX_FILE_LOCATION = "/etc/avaya-base.loc";
    private List<String> avayaBases;
    private Os os;
    private Registry registry;

    public AvayaBaseInventory(Os os) throws AvayaBaseInventoryException {
        if (os == null) {
            throw new NullPointerException("Os enum is null.");
        }
        this.avayaBases = new ArrayList<String>();
        this.os = os;
        if (os == Os.WINDOWS) {
            try {
                this.loadWindows();
            }
            catch (Exception e) {
                String error = "Error while fetching details from registry.";
                throw new AvayaBaseInventoryException(error, e);
            }
        } else if (os == Os.UNIX) {
            try {
                this.loadUnix();
            }
            catch (IOException e) {
                String error = "Error while fetching details from :/etc/avaya-base.loc";
                throw new AvayaBaseInventoryException(error, e);
            }
        } else {
            String error = "Unsupported Operating System.";
            throw new AvayaBaseInventoryException(error, null);
        }
    }

    private void add(String avayaBase) {
        if (avayaBase != null && avayaBase.trim().length() > 0 && !this.avayaBases.contains(avayaBase.trim())) {
            this.avayaBases.add(avayaBase.trim());
        }
    }

    private void remove(String avayaBase) {
        if (avayaBase != null) {
            this.avayaBases.remove(avayaBase.trim());
        }
    }

    public String[] getAvayaBases() {
        return this.avayaBases.toArray(new String[this.avayaBases.size()]);
    }

    private void update() throws AvayaBaseInventoryException {
        if (this.os == Os.WINDOWS) {
            try {
                this.updateWindows();
            }
            catch (NativeLibException e) {
                String error = "Error while storing details to registry.";
                throw new AvayaBaseInventoryException(error, e);
            }
        }
        if (this.os == Os.UNIX) {
            try {
                this.updateUnix();
            }
            catch (IOException e) {
                String error = "Error while storing details to: /etc/avaya-base.loc";
                throw new AvayaBaseInventoryException(error, e);
            }
        }
    }

    private void loadWindows() throws Exception {
        this.registry = new Registry();
        boolean keyExists = this.registry.exist(-2147483646, MS_WIN_AIF_REG_KEY);
        if (!keyExists) {
            this.registry.createKey(-2147483646, MS_WIN_AIF_REG_KEY);
        }
        RegDataContainer values = null;
        try {
            values = this.registry.getValue(-2147483646, MS_WIN_AIF_REG_KEY, MS_WIN_AIF_AVAYA_BASE_REG_VAL);
        }
        catch (NativeLibException e) {
            String libMessage = e.getLibMessage();
            if ("functionFailed.RegQueryValueEx".equals(libMessage)) {
                this.registry.setValueN(-2147483646, MS_WIN_AIF_REG_KEY, MS_WIN_AIF_AVAYA_BASE_REG_VAL, new RegDataContainer(new String[0]));
            }
            throw e;
        }
        if (values != null) {
            String[] valuesAsString;
            for (String value : valuesAsString = values.getMultiStringData()) {
                if (value == null || value.trim().length() <= 0) continue;
                this.avayaBases.add(value.trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUnix() throws IOException {
        File avayaBaseFile = new File(UNIX_FILE_LOCATION);
        if (!avayaBaseFile.exists()) {
            avayaBaseFile.createNewFile();
        }
        if (!avayaBaseFile.canWrite()) {
            throw new IOException("No write access for file: /etc/avaya-base.loc");
        }
        BufferedReader reader = new BufferedReader(new FileReader(avayaBaseFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmedLine = line.trim();
                if (trimmedLine.length() <= 0) continue;
                this.avayaBases.add(trimmedLine);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void updateWindows() throws NativeLibException {
        RegDataContainer data = new RegDataContainer(this.getAvayaBases());
        this.registry.setValueN(-2147483646, MS_WIN_AIF_REG_KEY, MS_WIN_AIF_AVAYA_BASE_REG_VAL, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnix() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(UNIX_FILE_LOCATION, false));
        try {
            for (String avayaBase : this.avayaBases) {
                writer.write(avayaBase + "\n");
            }
            writer.flush();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void addAvayaBase(String installPath) throws Exception {
        if (!this.isAvayaBasePresent(installPath = new File(installPath).getAbsolutePath())) {
            this.add(installPath);
            this.update();
        }
    }

    public void removeAvayaBase(String installPath) throws Exception {
        if (this.isAvayaBasePresent(installPath = new File(installPath).getAbsolutePath())) {
            this.remove(installPath);
            this.update();
        }
    }

    private boolean isAvayaBasePresent(String installPath) {
        boolean present = false;
        if (this.os == Os.WINDOWS) {
            String newInstallPath = installPath.toUpperCase();
            for (String avayaBase : this.avayaBases) {
                if (!newInstallPath.equals(avayaBase = avayaBase.toUpperCase())) continue;
                present = true;
            }
        } else {
            for (String avayaBase : this.avayaBases) {
                if (!installPath.equals(avayaBase)) continue;
                present = true;
            }
        }
        return present;
    }

    public class AvayaBaseInventoryException
    extends Exception {
        public AvayaBaseInventoryException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Os {
        WINDOWS("Windows"),
        UNIX("Unix");

        private String os;

        private Os(String os) {
            this.os = os;
        }

        public String toString() {
            return this.os;
        }
    }
}

