/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.installer;

import com.avaya.panther.installer.AvayaHomeKeeper;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.installer.IResponseFileHandler;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.util.AvayaProperties;
import com.avaya.panther.util.PasswordUtility;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class UninstallResponseFileHandler
implements IResponseFileHandler {
    private String inputFile;
    private String outputFile;
    private AutomatedInstallData idata;

    public UninstallResponseFileHandler(AutomatedInstallData idata) {
        this.idata = idata;
        this.outputFile = new File(AvayaInstaller.panther.getOutputUninstallResponseFile()).isAbsolute() ? AvayaInstaller.panther.getOutputUninstallResponseFile() : InventoryUtil.getInventory().getInstallPath() + File.separatorChar + AvayaInstaller.panther.getOutputUninstallResponseFile();
        this.inputFile = AvayaInstaller.panther.getResFileLoc();
    }

    public void compareInputOutputResponseFile() throws MalformedURLException, IOException {
        InputStream inputStream = this.outputFile != null && new File(this.outputFile).exists() ? new File(this.outputFile).toURL().openStream() : null;
        InputStream stream = this.inputFile != null && new File(this.inputFile).exists() ? new File(this.inputFile).toURL().openStream() : null;
        Debug.log("Configuration parameters that are changed (from the input response file)");
        Debug.log("------------------------------------------------------------------------------------------");
        if (inputStream != null && stream != null) {
            Properties inputProperties = new Properties();
            Properties outputProperties = new Properties();
            outputProperties.load(inputStream);
            inputProperties.load(stream);
            Enumeration<Object> output = outputProperties.keys();
            while (output.hasMoreElements()) {
                String value;
                String varName = (String)output.nextElement();
                String varValue = outputProperties.getProperty(varName);
                if (!inputProperties.containsKey(varName) || varValue.equals(value = inputProperties.getProperty(varName))) continue;
                Debug.log("Variable " + varName + " has been changed from " + value + " to " + varValue);
            }
        }
        Debug.log("------------------------------------------------------------------------------------------");
        AvayaHomeKeeper.finalActions(this.idata);
    }

    public void writeOutputResponseFile(AutomatedInstallData idata) throws Exception {
        AvayaProperties property = new AvayaProperties();
        Iterator panelIterator = idata.panelsOrder.iterator();
        PasswordUtility passwordUtility = new PasswordUtility();
        if (null != idata.getVariable("ALL_PASSWD_FIELDS")) {
            passwordUtility.encryptPasswdFields(idata);
        }
        while (panelIterator.hasNext()) {
            Panel p = (Panel)panelIterator.next();
            String panelClassName = p.className.substring(p.className.lastIndexOf(".") + 1);
            String prefix = "com.avaya.panther.panels.Av";
            String automationHelperClassName = prefix + panelClassName + "AutomationHelper";
            Class<?> automationHelperClass = null;
            try {
                automationHelperClass = Class.forName(automationHelperClassName);
            }
            catch (ClassNotFoundException e1) {
                Debug.trace("ClassNotFoundException-skip :" + automationHelperClassName);
                continue;
            }
            AvayaPanelAutomation automationHelperInstance = null;
            if (automationHelperClass != null) {
                try {
                    Debug.trace("Instantiate :" + automationHelperClassName);
                    automationHelperInstance = (AvayaPanelAutomation)automationHelperClass.newInstance();
                }
                catch (Exception e1) {
                    Debug.trace("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
                    continue;
                }
            }
            automationHelperInstance.generatePropertyFile(property, idata);
        }
        try {
            new File(this.outputFile).createNewFile();
            property.store(new FileOutputStream(this.outputFile), null);
            Debug.log(idata.langpack.getString("output.response.file") + " " + this.outputFile + " " + idata.langpack.getString("generated"));
            System.out.println("output.response.file " + this.outputFile + " " + idata.langpack.getString("generated"));
            Debug.log(idata.langpack.getString("configuration.used"));
            Debug.log("------------------------------------------------------------------------------------------");
            Enumeration<Object> enumeration = property.keys();
            while (enumeration.hasMoreElements()) {
                String variableName = (String)enumeration.nextElement();
                if (variableName.startsWith("#")) continue;
                Debug.log(variableName + ": " + property.getProperty(variableName));
            }
            Debug.log("------------------------------------------------------------------------------------------");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

