/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.installer;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class CAFWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "CAFPanel.Spec.xml";
    private final VariableSubstitutor vs;
    private final ArrayList jobs = new ArrayList();
    private boolean result = true;
    private static PrintWriter logfile = null;
    private String logfiledir = null;
    protected AbstractUIProcessHandler handler;
    protected AutomatedInstallData idata;
    private String instanceNumber;
    private String panelID;
    private static LocaleDatabase langpack = null;

    public CAFWorker(AutomatedInstallData idata, AbstractUIProcessHandler handler, String instanceNumber) throws IOException {
        this.handler = handler;
        this.idata = idata;
        this.instanceNumber = instanceNumber;
        this.vs = new VariableSubstitutor(idata.getVariables());
        langpack = idata.langpack;
    }

    public CAFWorker(AutomatedInstallData idata, AbstractUIProcessHandler handler, String panelID, String instanceNumber) throws IOException {
        this.handler = handler;
        this.idata = idata;
        this.vs = new VariableSubstitutor(idata.getVariables());
        this.panelID = panelID;
        this.instanceNumber = instanceNumber;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public String getPanelID() {
        return this.panelID;
    }

    public void setPanelID(String panelID) {
        this.panelID = panelID;
    }

    private boolean readSpec() throws IOException {
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setValidator(new NonValidator());
        XMLElement data = null;
        try {
            parser.setReader(new StdXMLReader(input));
            data = (XMLElement)parser.parse();
        }
        catch (Exception e) {
            System.err.println("Error parsing XML specification for processing.");
            System.err.println(e.toString());
            Debug.error("Error parsing XML specification for processing.");
            Debug.error(e.toString());
            return false;
        }
        if (!data.hasChildren()) {
            return false;
        }
        Vector specElements = null;
        XMLElement spec = null;
        if (data.hasChildren()) {
            specElements = data.getChildrenNamed("panel");
            for (int i = 0; i < specElements.size(); ++i) {
                data = (XMLElement)specElements.elementAt(i);
                String attribute = data.getAttribute("order");
                String panelattribute = data.getAttribute("id");
                if ((attribute == null || !this.instanceNumber.equals(attribute)) && (panelattribute == null || this.panelID == null || !this.panelID.equals(panelattribute))) continue;
                spec = data;
                input.close();
                break;
            }
        }
        if (spec != null) {
            XMLElement lfd = spec.getFirstChildNamed("logfiledir");
            if (lfd != null) {
                this.logfiledir = lfd.getContent();
            }
            this.jobs.clear();
            for (XMLElement job_el : spec.getChildrenNamed("job")) {
                List constraints;
                String conditionid = job_el.getAttribute("conditionid");
                if (conditionid != null) {
                    Debug.trace("Condition for job.");
                    Condition cond = RulesEngine.getCondition(conditionid);
                    if (cond != null && !cond.isTrue()) {
                        Debug.trace("condition is not fulfilled.");
                        continue;
                    }
                }
                Debug.trace("Condition is fulfilled or not existent.");
                Vector forPacks = job_el.getChildrenNamed("executeForPack");
                if (!this.jobRequiredFor(forPacks) || !OsConstraint.oneMatchesCurrentSystem(constraints = OsConstraint.getOsList(job_el))) continue;
                ArrayList<ExecutableFile> ef_list = new ArrayList<ExecutableFile>();
                String job_name = job_el.getAttribute("name", "");
                for (XMLElement ef : job_el.getChildrenNamed("executefile")) {
                    String ef_name = ef.getAttribute("name");
                    if (ef_name == null || ef_name.length() == 0) {
                        System.err.println("missing \"name\" attribute for <executefile>");
                        Debug.error("missing \"name\" attribute for <executefile>");
                        return false;
                    }
                    String onFaliure = ef.getAttribute("failure");
                    int faliure = 0;
                    if (onFaliure == null) {
                        faliure = 3;
                    } else {
                        if (onFaliure.contains("$")) {
                            String variable = onFaliure.substring(1, onFaliure.length());
                            onFaliure = this.idata.getVariable(variable);
                        }
                        if (onFaliure == null) {
                            faliure = 3;
                        } else if (onFaliure.equals("abort")) {
                            faliure = 0;
                        } else if (onFaliure.equals("warn")) {
                            faliure = 1;
                        } else if (onFaliure.equals("success")) {
                            faliure = 3;
                        }
                    }
                    ArrayList<String> args = new ArrayList<String>();
                    for (XMLElement arg_el : ef.getChildrenNamed("arg")) {
                        String arg_val = arg_el.getContent();
                        args.add(arg_val);
                    }
                    ef_list.add(new ExecutableFile(ef_name, args, faliure));
                }
                this.jobs.add(new ProcessingJob(job_name, ef_list));
            }
        }
        return true;
    }

    public void run() {
        try {
            if (!this.readSpec()) {
                System.err.println("Error parsing XML specification for processing.");
                Debug.error("Error parsing XML specification for processing.");
                return;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            Debug.error(ioe.toString());
            return;
        }
        if (this.logfiledir != null) {
            this.logfiledir = IoHelper.translatePath(this.logfiledir, new VariableSubstitutor(this.idata.getVariables()));
            String appName = this.idata.getVariable("APP_NAME");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh.mm.ss");
            Date date = new Date();
            appName = appName != null ? appName.replaceAll("[^-a-zA-z0-9_]", "_").replaceAll("\\\\", "_") : "";
            appName = appName.toLowerCase();
            String logFileName = appName + "_" + "process_panel" + "_" + dateFormat.format(date) + ".log";
            String logFilePath = new File(this.logfiledir, logFileName).getAbsolutePath();
            try {
                File lf = new File(logFilePath);
                logfile = new PrintWriter(new FileOutputStream(lf), true);
            }
            catch (IOException e) {
                Debug.error(e);
            }
        }
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob pj : this.jobs) {
            this.handler.startProcess(pj.name);
            this.result = pj.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        this.handler.finishProcessing();
        if (logfile != null) {
            logfile.close();
        }
    }

    public void startThread() {
        Thread processingThread = new Thread((Runnable)this, "processing thread");
        processingThread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean jobRequiredFor(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getJobs() {
        return this.jobs;
    }

    private static class ExecutableFile
    implements Processable {
        private final String filename;
        private final List arguments;
        public final int onfaliure;
        protected AbstractUIProcessHandler handler;

        public ExecutableFile(String fn, List args, int onfaliure) {
            this.filename = fn;
            this.arguments = args;
            this.onfaliure = onfaliure;
        }

        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            this.handler = handler;
            String[] params = new String[this.arguments.size() + 1];
            if (params != null && params.length > 0) {
                params[0] = vs.substitute(this.filename, "plain");
            }
            int i = 1;
            Iterator arg_it = this.arguments.iterator();
            while (arg_it.hasNext()) {
                params[i++] = vs.substitute((String)arg_it.next(), "plain");
            }
            try {
                if (params != null && params.length > 0) {
                    Debug.log("Started executing " + params[0]);
                }
                Process p = Runtime.getRuntime().exec(params);
                OutputMonitor stdoutMon = new OutputMonitor(this.handler, p.getInputStream(), false);
                OutputMonitor stderrMon = new OutputMonitor(this.handler, p.getErrorStream(), true);
                Thread stdoutThread = new Thread(stdoutMon);
                Thread stderrThread = new Thread(stderrMon);
                stdoutThread.setDaemon(true);
                stderrThread.setDaemon(true);
                stdoutThread.start();
                stderrThread.start();
                try {
                    int exitStatus = p.waitFor();
                    this.stopMonitor(stdoutMon, stdoutThread);
                    this.stopMonitor(stderrMon, stderrThread);
                    String[] output = new String[2];
                    output[0] = stdoutMon.toString();
                    Debug.trace("stdout:");
                    Debug.trace(output[0]);
                    output[1] = stderrMon.toString();
                    Debug.trace("stderr:");
                    Debug.trace(output[1]);
                    String message = output[0] + "\n" + output[1];
                    message = AvayaInstallerBase.replacePassword(message);
                    if (message.length() == 1) {
                        message = langpack.getString("file.execute.fail.message") + this.filename + ".";
                    }
                    if (exitStatus != 0) {
                        if (AvayaInstaller.panther.getInstallStage().equals("preinstall")) {
                            AvayaInstaller.panther.setPreInstallStatus("error");
                        }
                        if (AvayaInstaller.panther.getInstallationMode().equals("gui") && AvayaInstaller.panther.getInstallStage().equals("preinstall")) {
                            ++AvayaInstallData.install_warnings_count;
                        }
                        if (!AvayaInstaller.panther.getInstallStage().equals("preinstall")) {
                            ++AvayaInstallData.install_warnings_count;
                        }
                    } else {
                        Debug.log("Execution of " + this.filename + " Completed");
                    }
                }
                catch (InterruptedException ie) {
                    p.destroy();
                    AvayaInstaller.panther.setInstallStatus("error");
                    this.handler.emitError("process interrupted", ie.toString());
                    Debug.error("process interrupted\n" + ie.toString());
                    return false;
                }
            }
            catch (IOException ioe) {
                AvayaInstaller.panther.setInstallStatus("error");
                this.handler.emitError("I/O error", ioe.toString());
                Debug.error("I/O error\n" + ioe.toString());
                return false;
            }
            return true;
        }

        private void stopMonitor(OutputMonitor m, Thread t) {
            m.doStop();
            long softTimeout = 500L;
            try {
                t.join(softTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!t.isAlive()) {
                return;
            }
            t.interrupt();
            long hardTimeout = 500L;
            try {
                t.join(hardTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        public static class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private final AbstractUIProcessHandler handler;
            private final BufferedReader reader;
            private Boolean stop = false;

            public OutputMonitor(AbstractUIProcessHandler handler, InputStream is, boolean stderr) {
                this.stderr = stderr;
                this.reader = new BufferedReader(new InputStreamReader(is));
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        this.handler.logOutput(line, this.stderr);
                        Debug.log(line);
                        if (logfile != null) {
                            logfile.println(line);
                        }
                        Boolean bl = this.stop;
                        synchronized (bl) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    this.handler.logOutput(ioe.toString(), true);
                    if (logfile == null) return;
                    logfile.println(ioe.toString());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl = this.stop;
                synchronized (bl) {
                    this.stop = true;
                }
            }
        }
    }

    private static class ProcessingJob
    implements Processable {
        public String name;
        private final List processables;

        public ProcessingJob(String name, List processables) {
            this.name = name;
            this.processables = processables;
        }

        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            for (Processable pr : this.processables) {
                if (pr.run(handler, vs)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

