/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.installer;

import com.avaya.panther.installer.AvayaInstaller;
import com.avaya.panther.installer.AvayaPanelAutomation;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Pack;
import com.avaya.panther.inventory.beans.Version;
import com.avaya.panther.util.HidePassword;
import com.avaya.panther.util.PasswordEncryptionandDecrpytion;
import com.avaya.panther.util.PasswordUtility;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvayaInstallerBase {
    private static FileOutputStream outputStream = null;
    private static List<String> allPasswordValues = null;

    public static void loadCustomVariables(AutomatedInstallData installData, String resource) throws Exception {
        String allPwdFields;
        InputStream inputStream = new File(resource).toURL().openStream();
        Properties variables = null;
        if (null != inputStream) {
            variables = new Properties();
            variables.load(inputStream);
        }
        if (null != variables) {
            String varValue = variables.getProperty("localeISO3");
            if (varValue != null) {
                Boolean validLocale = false;
                for (int i = 0; i < GUIInstaller.LANG_CODES.length; ++i) {
                    if (!GUIInstaller.LANG_CODES[i][0].equals(varValue)) continue;
                    installData.localeISO3 = varValue;
                    validLocale = true;
                }
                if (!validLocale.booleanValue()) {
                    String error = "Invalid Locale: " + varValue;
                    System.out.println(error);
                    Debug.error(error);
                    System.exit(1);
                }
            }
            installData.addAllVariables(variables);
        }
        if (null == installData.localeISO3) {
            installData.localeISO3 = "eng";
        }
        if (null != (allPwdFields = installData.getVariable("ALL_PASSWD_FIELDS")) && !"".equals(allPwdFields) && (null == PasswordEncryptionandDecrpytion.USER_INPUT_KEY || PasswordEncryptionandDecrpytion.USER_INPUT_KEY.equals(""))) {
            PasswordEncryptionandDecrpytion.USER_INPUT_KEY = HidePassword.readPassword("Enter the Encryption Key :");
        }
        if (null != allPwdFields && !"".equals(allPwdFields)) {
            installData.setVariable("EncryptionKey", PasswordEncryptionandDecrpytion.USER_INPUT_KEY);
            PasswordUtility passwordUtility = new PasswordUtility();
            passwordUtility.createEncryptPasswdFields(installData);
            passwordUtility.decryptPasswdFields(installData);
            passwordUtility.encryptResponseFile(new File(resource), installData);
        }
    }

    public static void resolveLocale(AutomatedInstallData installData) throws Exception {
        String localeCode = null;
        for (int i = 0; i < GUIInstaller.LANG_CODES.length; ++i) {
            if (!GUIInstaller.LANG_CODES[i][0].equals(installData.localeISO3)) continue;
            localeCode = GUIInstaller.LANG_CODES[i][1];
        }
        Locale locale = new Locale(localeCode);
        installData.setVariable("SelectedLocale", locale.getDisplayName());
        Debug.log(localeCode);
    }

    public static void setSpecialInstallVariables(AutomatedInstallData installData) throws Exception {
        if (null != installData.localeISO3) {
            InputStream in = ResourceManager.class.getResourceAsStream("/langpacks/" + installData.localeISO3 + ".xml");
            if (in == null) {
                Debug.log("The selected locale is not supported. Please enter 'eng' as 'language selection code' in input response file");
                System.out.println("Please enter 'eng' as 'language selection locale' in input response file");
                System.exit(1);
            }
            installData.langpack = new LocaleDatabase(in);
            installData.setVariable("ISO3_LANG", installData.localeISO3);
            installData.setVariable("SelectedLocale", installData.localeISO3);
        }
    }

    public void setPanelVariables(AutomatedInstallData installData) {
        if (AvayaInstaller.panther.getInstallationMode().equals("gui")) {
            for (Panel p : installData.panelsOrder) {
                String panelClassName = p.className.substring(p.className.lastIndexOf(".") + 1);
                String prefix = "com.avaya.panther.panels.Av";
                String automationHelperClassName = prefix + panelClassName + "AutomationHelper";
                Class<?> automationHelperClass = null;
                try {
                    automationHelperClass = Class.forName(automationHelperClassName);
                }
                catch (ClassNotFoundException e1) {
                    Debug.trace("ClassNotFoundException-skip :" + automationHelperClassName);
                    continue;
                }
                AvayaPanelAutomation automationHelperInstance = null;
                if (automationHelperClass != null) {
                    try {
                        Debug.trace("Instantiate :" + automationHelperClassName);
                        automationHelperInstance = (AvayaPanelAutomation)automationHelperClass.newInstance();
                    }
                    catch (Exception e1) {
                        Debug.trace("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
                        continue;
                    }
                }
                automationHelperInstance.setVariables(installData);
            }
        }
    }

    public static List<com.izforge.izpack.Pack> getDependencyPackList(AutomatedInstallData installData, com.izforge.izpack.Pack pack) {
        ArrayList<com.izforge.izpack.Pack> dependencyPackList = new ArrayList<com.izforge.izpack.Pack>();
        if (null != pack.dependencies) {
            for (String dependencyPackName : pack.dependencies) {
                for (com.izforge.izpack.Pack availablePack : installData.availablePacks) {
                    if (!availablePack.name.equals(dependencyPackName)) continue;
                    dependencyPackList.add(availablePack);
                }
            }
            return dependencyPackList;
        }
        return null;
    }

    public static String generatePackMetadataPath(String packId) {
        return AvayaInstallerBase.generatePackMetadataPath(packId, null, null);
    }

    public static String generatePackMetadataPath(String packId, String version, String installPath) {
        String strPath = "";
        IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
        if (version == null || version.equals("")) {
            Version objVersion = inventoryUtil.getLastInstalledVersion(packId, false);
            version = objVersion != null ? objVersion.toString() : "";
        }
        if (!version.equals("")) {
            version = new Version(version).toString();
            if (installPath == null) {
                installPath = inventoryUtil.getInstallPath();
            }
            strPath = installPath + File.separator + "Uninstaller" + File.separator + packId + File.separator + version;
        }
        Debug.log("Metadata path for pack: " + packId + " :- " + strPath);
        return strPath;
    }

    public static String getVersionType(String version) {
        String versionType = "NON-PATCH";
        if (version != null) {
            version = new Version(version).toString();
            StringTokenizer st = new StringTokenizer(version, ".");
            int i = 0;
            while (st.hasMoreTokens()) {
                String currToken = st.nextToken();
                if (i == 3 && Integer.parseInt(currToken) != 0) {
                    return "PATCH";
                }
                ++i;
            }
        }
        return versionType;
    }

    public static String replacePassword(String strMessage) {
        if (allPasswordValues == null) {
            AvayaInstallerBase.populateAllPasswordValueList();
        }
        String encryptedPasswd = "*****";
        if (strMessage == null || strMessage.equals("")) {
            String strReturn = "";
            StringTokenizer st = new StringTokenizer(strMessage, " ");
            while (st.hasMoreTokens()) {
                String currentWord = st.nextToken();
                if (allPasswordValues.indexOf("'" + currentWord + "'") > -1 || allPasswordValues.indexOf("\"" + currentWord + "\"") > -1 || allPasswordValues.indexOf(currentWord) > -1 || allPasswordValues.indexOf(currentWord + "\n") > -1) {
                    currentWord = "*****";
                }
                strReturn = strReturn + currentWord;
            }
            return strReturn;
        }
        return strMessage;
    }

    public static void createLockFile(String lockFilePath) {
        new File(lockFilePath).mkdirs();
        File lockFile = new File(lockFilePath + File.separator + "lock");
        if (!lockFile.exists()) {
            boolean fileCreated = false;
            try {
                fileCreated = lockFile.createNewFile();
            }
            catch (IOException e) {
                Debug.error(e);
                e.printStackTrace();
            }
            Debug.log(fileCreated ? "Lock file created successfully" : "Error in creating lock file");
            if (fileCreated) {
                try {
                    outputStream = new FileOutputStream(lockFile, true);
                }
                catch (FileNotFoundException e) {
                    Debug.error(e);
                    e.printStackTrace();
                }
            } else {
                System.exit(-1);
            }
        }
    }

    public static void writeToLockFile(String message) {
        try {
            outputStream.write("\n".getBytes());
            outputStream.write(message.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static void closeLockStream() {
        try {
            outputStream.close();
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static boolean isInstallTypeValid(List<String> installtype, String version) {
        if (installtype == null || installtype.isEmpty()) {
            return true;
        }
        String type = InventoryUtil.getInventory().getInstallType(version);
        return installtype.contains(type);
    }

    public static boolean isPackVersionInstalled(com.izforge.izpack.Pack pack) {
        List<Pack> installedPacksList = null;
        if (pack == null) {
            return false;
        }
        if (installedPacksList == null) {
            installedPacksList = InventoryUtil.getInventory().getInstalledPacks();
        }
        if (installedPacksList == null) {
            return false;
        }
        for (Pack p : installedPacksList) {
            if (p.getId().equals(pack.id) && p.getVersion() != null && p.getVersion().contains(new Version(pack.getVersion()))) {
                return true;
            }
            if (!p.getId().equals(pack.id) || p.getPatchversion() == null || !p.getPatchversion().contains(new Version(pack.getVersion()))) continue;
            return true;
        }
        return false;
    }

    public static void generatePropertyFile(Properties variables, String fileName, boolean writeAllPaswdField) throws Exception {
        String allCategoryList = variables.getProperty("ALL_CATEGORIES_LIST");
        if (allCategoryList != null && !allCategoryList.equals("")) {
            StringTokenizer categoryTokenizer = new StringTokenizer(allCategoryList, ",");
            String category = "";
            TreeMap<String, HashMap> catMap = new TreeMap<String, HashMap>();
            if (new File(fileName).exists()) {
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
                String line = "";
                String categoryName = "default";
                HashMap keyVal = new HashMap();
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("###")) continue;
                    if (line.startsWith("#")) {
                        categoryName = line.substring(1);
                        keyVal = (HashMap)keyVal.clone();
                        keyVal.clear();
                        catMap.put(categoryName, keyVal);
                        continue;
                    }
                    int index = line.lastIndexOf("=");
                    keyVal.put(line.substring(0, index).trim(), line.substring(index + 1).trim());
                }
                br.close();
            }
            while (categoryTokenizer.hasMoreTokens()) {
                String allKeys;
                category = categoryTokenizer.nextToken().trim();
                if (category == null || category.equals("") || (allKeys = variables.getProperty(category)) == null || allKeys.equals("")) continue;
                StringTokenizer allKeyTokenizer = new StringTokenizer(allKeys, ",");
                String key = "";
                String value = "";
                HashMap tmpMap = new HashMap();
                while (allKeyTokenizer.hasMoreTokens()) {
                    key = allKeyTokenizer.nextToken();
                    if (key.equals("")) continue;
                    value = variables.getProperty(key);
                    if (catMap.containsKey(category)) {
                        ((HashMap)catMap.get(category)).put(key, value);
                        continue;
                    }
                    tmpMap = (HashMap)tmpMap.clone();
                    tmpMap.clear();
                    tmpMap.put(key, value);
                    catMap.put(category, tmpMap);
                }
            }
            new File(fileName).createNewFile();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName, false)));
            bw.write("###Do not edit other part except key-value pair.\n");
            for (String nwCategory : catMap.keySet()) {
                bw.write("### Variables for " + nwCategory + " ###\n");
                bw.write("#" + nwCategory + "\n");
                HashMap keyValPair = (HashMap)catMap.get(nwCategory);
                for (String nwKey : keyValPair.keySet()) {
                    String nwValue = (String)keyValPair.get(nwKey);
                    bw.write(nwKey + "=" + nwValue + "\n");
                }
            }
            if (writeAllPaswdField) {
                bw.write("ALL_PASSWD_FIELDS=" + variables.getProperty("ALL_PASSWD_FIELDS") + "\n");
            }
            bw.close();
        } else {
            variables.store(new FileOutputStream(fileName), "#default");
        }
    }

    public static boolean isUninstall() {
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        return installData.getVariable("INSTALLER_MODE") != null && installData.getVariable("INSTALLER_MODE").equals("uninstall");
    }

    public static String encryptArgValues(String arg) {
        if (arg == null || arg.equals("")) {
            return arg;
        }
        if (allPasswordValues == null) {
            AvayaInstallerBase.populateAllPasswordValueList();
        }
        String encryptedArgument = new String("*****");
        if (allPasswordValues != null) {
            if (allPasswordValues.size() == 0) {
                return arg;
            }
            if (allPasswordValues.indexOf(arg) < 0) {
                return arg;
            }
            return encryptedArgument;
        }
        return encryptedArgument;
    }

    private static void populateAllPasswordValueList() {
        AutomatedInstallData installData = AutomatedInstallData.getInstance();
        String allPasswordFields = installData.getVariable("ALL_PASSWD_FIELDS");
        allPasswordValues = new ArrayList<String>();
        if (allPasswordFields != null && !allPasswordFields.trim().equals("")) {
            allPasswordFields = allPasswordFields + ",EncryptionKey";
            StringTokenizer st = new StringTokenizer(allPasswordFields, ",");
            while (st.hasMoreTokens()) {
                String passwordField = st.nextToken();
                if ((passwordField = passwordField.trim()).equals("")) continue;
                allPasswordValues.add(installData.getVariable(passwordField));
            }
        }
    }

    public static void addURLToClasspath(URL url) throws IOException {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = urlClassLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            if (!urls[i].toString().equalsIgnoreCase(url.toString())) continue;
            Debug.log("URL " + url + " is already in the CLASSPATH");
            return;
        }
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, url);
        }
        catch (Throwable t) {
            Debug.error(t.getMessage());
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

