/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.installer;

import com.avaya.panther.installer.AvayaInstallData;
import com.avaya.panther.inventory.AvayaBaseInventory;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.InputStreamReader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;

public class AvayaInstaller {
    public static AvayaInstallData panther;
    private boolean allowAvayaBaseDefinition;
    boolean isInstallation = true;
    public static String arguments;

    public AvayaInstaller() {
        panther = new AvayaInstallData();
    }

    public void setGlobalVariables(String[] args) {
        String error;
        panther.setAllowAvayaBaseDefinition(this.allowAvayaBaseDefinition);
        if ("gui".equals(args[0])) {
            panther.setInstallationMode("gui");
        } else if ("unattended".equals(args[0])) {
            panther.setInstallationMode("unattended");
        }
        String default_conf_file = "defConfParam.properties";
        if (this.confFileExists(default_conf_file)) {
            panther.setDefConFile(default_conf_file);
        } else {
            String info = "INFO : Default Configuration file (defConfParam.properties) not found";
            panther.setDefConFile(null);
            if (this.isInstallation) {
                System.out.println(info);
            }
        }
        panther.setResFileLoc(args[1]);
        if (panther.getResFileLoc() == null) {
            if (panther.getInstallationMode().equals("unattended")) {
                error = "ERROR : No Input Response file specified";
                System.out.println(error);
                if (!this.isInstallation) {
                    this.uninstallerUsage();
                } else {
                    this.usage();
                }
                System.exit(1);
            }
        } else if (!this.confFileExists(panther.getResFileLoc())) {
            error = "ERROR : Specified Response file does not exist: " + panther.getResFileLoc();
            System.out.println(error);
            System.exit(1);
        }
        if (args[2] != null) {
            panther.setOutputResponseFile(args[2]);
            panther.setOutputUninstallResponseFile(args[2]);
        }
        if (args[3].equalsIgnoreCase("true") || args[3].equalsIgnoreCase("false")) {
            panther.setRollBackOnFaliure(Boolean.parseBoolean(args[3].toLowerCase()));
        } else {
            this.usage();
        }
        if (args[4].equalsIgnoreCase("abort") || args[4].equalsIgnoreCase("ignore")) {
            panther.setPrerequisiteIgnorer(args[4].toLowerCase());
        } else {
            this.usage();
        }
        if (args[6].equalsIgnoreCase("true") || args[6].equalsIgnoreCase("false")) {
            panther.setRetainConfiguration(Boolean.parseBoolean(args[6].toLowerCase()));
        } else {
            this.uninstallerUsage();
        }
        if (args[7].equalsIgnoreCase("true") || args[7].equalsIgnoreCase("false")) {
            panther.setDoNotExecuteOnUninstall(Boolean.parseBoolean(args[7].toLowerCase()));
        } else {
            this.uninstallerUsage();
        }
    }

    private boolean confFileExists(String confFile) {
        return new File(confFile).exists();
    }

    public void usage() {
        String os = System.getProperty("os.name");
        if (null != os && os.toLowerCase().contains("windows")) {
            System.out.println("Usage: runInstaller.bat \nOptional Arguments\n[-m] gui/unattended");
            System.out.println("[-i] Input Response File (This option is mandatory for unattended installation)");
            System.out.println("[-o] Output Response File ");
            System.out.println("[-p] abort/ignore (action to be performed in case of pre-requisite failure)");
            System.out.println("[-c] true/false (Ignore file execution errors. This option is only for unattended installation. Default value is false)");
            System.out.println("[-t] true/false (Show Debug Trace)");
        } else {
            System.out.println("Usage: ./runInstaller.sh \nOptional Arguments \n[-m] gui/unattended");
            System.out.println("[-i] Input Response File (This option is mandatory for unattended installation)");
            System.out.println("[-o] Output Response File ");
            System.out.println("[-p] abort/ignore (action to be performed in case of pre-requisite failure)");
            System.out.println("[-c] true/false (Ignore file execution errors. This option is only for unattended installation. Default value is false)");
            System.out.println("[-t] true/false (Show Debug Trace)");
        }
        System.exit(1);
    }

    public void evaluateCmdLineArgs(String[] args) {
        String[] global_vars = new String[]{"gui", null, null, "true", "ignore", "false", "false", "false"};
        boolean isAvayaBaseOptionSpecified = false;
        if (args.length >= 2 && args[0].equals("-u") && args[1].equals("true")) {
            this.isInstallation = false;
            panther.setContinueOnFailure(true);
            global_vars[4] = "abort";
        }
        Options opt = new Options();
        if (this.isInstallation) {
            opt.addOption("m", true, "Mode");
            opt.addOption("i", true, "Input Response File");
            opt.addOption("o", true, "Output File");
            opt.addOption("r", true, "Rollback Option");
            opt.addOption("p", true, "Pre-requisite failure Option");
            opt.addOption("a", true, "Accessibility Option");
            opt.addOption("t", true, "Stacktrace Option");
            opt.addOption("b", true, "Base");
            opt.addOption("c", true, "continue on failure");
        } else {
            opt.addOption("m", true, "Mode");
            opt.addOption("u", true, "Component Information");
            opt.addOption("i", true, "Input Response File");
            opt.addOption("o", true, "Output File");
            opt.addOption("e", true, "Do not execute uninstall scripts");
            opt.addOption("f", true, "Retain files after uninstallation");
            opt.addOption("t", true, "Stacktrace Option");
        }
        try {
            InputStreamReader br;
            int answer;
            BasicParser parser = new BasicParser();
            CommandLine cl = parser.parse(opt, args, true);
            if (cl != null && cl.getArgList() != null && cl.getArgList().size() > 0) {
                if (!this.isInstallation) {
                    this.uninstallerUsage();
                } else {
                    this.usage();
                }
            }
            if (cl.getOptionValue("u") != null) {
                global_vars[5] = cl.getOptionValue("u");
            }
            if (cl.getOptionValue("m") != null) {
                if (cl.getOptionValue("m").equalsIgnoreCase("gui") || cl.getOptionValue("m").equalsIgnoreCase("unattended")) {
                    global_vars[0] = cl.getOptionValue("m");
                    arguments = arguments + "-m " + cl.getOptionValue("m");
                } else {
                    System.out.println("ERROR : Invalid Mode Option");
                    if (!this.isInstallation) {
                        this.uninstallerUsage();
                    } else {
                        this.usage();
                    }
                    System.exit(-1);
                }
            }
            if (cl.getOptionValue("i") != null) {
                global_vars[1] = cl.getOptionValue("i");
                arguments = arguments + " -i " + cl.getOptionValue("i");
            }
            if (cl.getOptionValue("o") != null) {
                global_vars[2] = cl.getOptionValue("o");
            }
            if (cl.getOptionValue("f") != null) {
                if (global_vars[5].equalsIgnoreCase("true")) {
                    global_vars[6] = cl.getOptionValue("f");
                    arguments = arguments + " -f " + cl.getOptionValue("f");
                } else {
                    this.usage();
                }
            }
            if (cl.getOptionValue("f") == null && global_vars[5].equalsIgnoreCase("true")) {
                answer = 97;
                while (answer != 121 && answer != 110) {
                    br = new InputStreamReader(System.in);
                    System.out.println("Do you want to retain Configuration files ? (y/n) : ");
                    answer = (char)br.read();
                    if (answer != 121 && answer != 110) {
                        System.out.println("Invalid response.");
                    }
                    if (answer != 121) continue;
                    global_vars[6] = "true";
                    break;
                }
            }
            if (cl.getOptionValue("e") != null) {
                if (global_vars[5].equalsIgnoreCase("true") || global_vars[5].equalsIgnoreCase("false")) {
                    global_vars[7] = cl.getOptionValue("e");
                    arguments = arguments + " -e " + cl.getOptionValue("e");
                } else {
                    this.usage();
                }
            }
            if (cl.getOptionValue("e") == null && global_vars[5].equalsIgnoreCase("true")) {
                answer = 97;
                while (answer != 121 && answer != 110) {
                    br = new InputStreamReader(System.in);
                    System.out.println("Do you want to retain Configuration changes ? (y/n) : ");
                    answer = (char)br.read();
                    if (answer != 121 && answer != 110) {
                        System.out.println("Invalid response.");
                    }
                    if (answer != 121) continue;
                    global_vars[7] = "true";
                    break;
                }
            }
            if (cl.getOptionValue("r") != null) {
                if (cl.getOptionValue("r").equalsIgnoreCase("true") || cl.getOptionValue("r").equalsIgnoreCase("false")) {
                    global_vars[3] = cl.getOptionValue("r");
                    arguments = arguments + " -r " + cl.getOptionValue("r");
                } else {
                    System.out.println("ERROR : Invalid Rollback Option");
                    this.usage();
                    System.exit(-1);
                }
            }
            if (cl.getOptionValue("p") != null) {
                if (cl.getOptionValue("p").equalsIgnoreCase("abort") || cl.getOptionValue("p").equalsIgnoreCase("ignore")) {
                    global_vars[4] = cl.getOptionValue("p");
                    arguments = arguments + " -p " + cl.getOptionValue("p");
                } else {
                    System.out.println("ERROR : Invalid Pre-requisite Failure Option");
                    this.usage();
                    System.exit(-1);
                }
            }
            if (cl.getOptionValue("p") == null && cl.getOptionValue("p") != null && cl.getOptionValue("p").equalsIgnoreCase("unattended")) {
                global_vars[4] = "abort";
                arguments = arguments + " -p " + cl.getOptionValue("m");
            }
            if (cl.getOptionValue("c") != null && cl.getOptionValue("m").equalsIgnoreCase("unattended")) {
                if (cl.getOptionValue("c").equalsIgnoreCase("true") || cl.getOptionValue("c").equalsIgnoreCase("false")) {
                    panther.setContinueOnFailure(Boolean.parseBoolean(cl.getOptionValue("c")));
                    arguments = arguments + " -c " + cl.getOptionValue("c");
                } else {
                    this.usage();
                }
            }
            if (cl.getOptionValue("a") != null) {
                if (cl.getOptionValue("a").equalsIgnoreCase("true") || cl.getOptionValue("a").equalsIgnoreCase("false")) {
                    panther.setAccessibility(Boolean.parseBoolean(cl.getOptionValue("a")));
                    arguments = arguments + " -a " + cl.getOptionValue("a");
                } else {
                    System.out.println("ERROR : Invalid Accessibility Option");
                    this.usage();
                    System.exit(-1);
                }
            }
            if (cl.getOptionValue("t") != null) {
                if (cl.getOptionValue("t").equalsIgnoreCase("true") || cl.getOptionValue("t").equalsIgnoreCase("false")) {
                    System.setProperty("STACKTRACE", cl.getOptionValue("t"));
                    arguments = arguments + " -t " + cl.getOptionValue("t");
                } else {
                    System.out.println("ERROR : Invalid Stacktrace Option");
                    if (!this.isInstallation) {
                        this.uninstallerUsage();
                    } else {
                        this.usage();
                    }
                    System.exit(-1);
                }
            }
            if (cl.getOptionValue("b") != null) {
                if (cl.getOptionValue("b").equals("true") || cl.getOptionValue("b").equals("false")) {
                    isAvayaBaseOptionSpecified = true;
                    this.allowAvayaBaseDefinition = Boolean.valueOf(cl.getOptionValue("b"));
                    arguments = arguments + " -b " + cl.getOptionValue("b");
                } else {
                    this.usage();
                    System.exit(-1);
                }
            }
        }
        catch (MissingArgumentException e) {
            System.out.println("Missing Argument");
            if (!this.isInstallation) {
                this.uninstallerUsage();
            } else {
                this.usage();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (!isAvayaBaseOptionSpecified) {
            AvayaBaseInventory avayaBaseInventory = null;
            try {
                avayaBaseInventory = OsVersion.IS_WINDOWS ? new AvayaBaseInventory(AvayaBaseInventory.Os.WINDOWS) : new AvayaBaseInventory(AvayaBaseInventory.Os.UNIX);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.allowAvayaBaseDefinition = avayaBaseInventory.getAvayaBases() != null && avayaBaseInventory.getAvayaBases().length == 0;
        }
        this.setGlobalVariables(global_vars);
    }

    private void uninstallerUsage() {
        String os = System.getProperty("os.name");
        if (null != os && os.toLowerCase().contains("windows")) {
            System.out.println("Usage: runUninstaller.bat \nOptional Arguments\n[-m] gui/unattended");
            System.out.println("[-i] Input Response File (This option is mandatory for unattended uninstallation)");
            System.out.println("[-o] Output Response File ");
            System.out.println("[-t] true/false (Show Debug Trace)");
            System.out.println("[-e] Do not execute uninstall scripts (applicable to scripts for whom the uninstallflag is set to true)");
            System.out.println("[-f] Retain files after uninstallation (applicable to files for whom the uninstallflag is set to true)");
        } else {
            System.out.println("Usage: ./runUninstaller.sh \nOptional Arguments \n[-m] gui/unattended");
            System.out.println("[-i] Input Response File (This option is mandatory for unattended uninstallation)");
            System.out.println("[-o] Output Response File ");
            System.out.println("[-t] true/false (Show Debug Trace)");
            System.out.println("[-e] Do not execute uninstall scripts (applicable to scripts for whom the uninstallflag is set to true)");
            System.out.println("[-f] Retain files after uninstallation (applicable to files for whom the uninstallflag is set to true)");
        }
        System.exit(1);
    }

    static {
        arguments = "";
    }
}

