/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.installer;

import com.avaya.panther.installer.AvayaCheckBoxNode;
import com.izforge.izpack.panels.AvayaInventoryPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class AvayaCheckBoxNodeRenderer
implements TreeCellRenderer {
    private static final JPanel rendererPanel = new JPanel();
    private static final JCheckBox checkbox = new JCheckBox();
    private static final Font normalFont = new JCheckBox().getFont();
    private static final Font boldFont = new Font(normalFont.getFontName(), 1, normalFont.getSize());
    private static Color selectionForeground;
    private static Color selectionBackground;
    private static Color textForeground;
    private static Color textBackground;
    AvayaInventoryPanel avayaInventoryPanel;

    public AvayaCheckBoxNodeRenderer(AvayaInventoryPanel avayaInventoryPanel) {
        selectionForeground = UIManager.getColor("Tree.selectionForeground");
        selectionBackground = UIManager.getColor("Tree.selectionBackground");
        textForeground = UIManager.getColor("Tree.textForeground");
        textBackground = UIManager.getColor("Tree.textBackground");
        this.avayaInventoryPanel = avayaInventoryPanel;
        int treeWidth = avayaInventoryPanel.getTree() != null ? avayaInventoryPanel.getTree().getPreferredSize().width : 0;
        int height = AvayaCheckBoxNodeRenderer.checkbox.getPreferredSize().height;
        int cellWidth = treeWidth - treeWidth / 4;
        rendererPanel.setLayout(new BorderLayout(0, 0));
        rendererPanel.setBackground(textBackground);
        rendererPanel.add("West", checkbox);
        rendererPanel.setAlignmentX(0.0f);
        rendererPanel.setAlignmentY(0.0f);
        rendererPanel.setMinimumSize(new Dimension(cellWidth, height));
        rendererPanel.setPreferredSize(new Dimension(cellWidth, height));
        rendererPanel.setSize(new Dimension(cellWidth, height));
        rendererPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            checkbox.setForeground(selectionForeground);
            checkbox.setBackground(selectionBackground);
            rendererPanel.setForeground(selectionForeground);
            rendererPanel.setBackground(selectionBackground);
        } else {
            checkbox.setForeground(textForeground);
            checkbox.setBackground(textBackground);
            rendererPanel.setForeground(textForeground);
            rendererPanel.setBackground(textBackground);
        }
        if (value != null && value instanceof AvayaCheckBoxNode) {
            AvayaCheckBoxNode node = (AvayaCheckBoxNode)value;
            checkbox.setText(node.getText());
            checkbox.setSelected(node.isSelected());
            if (node.getChildCount() > 0) {
                checkbox.setFont(boldFont);
            } else {
                checkbox.setFont(normalFont);
            }
            checkbox.setIcon(checkbox.getIcon());
        }
        return rendererPanel;
    }

    public Component getCheckRenderer() {
        return rendererPanel;
    }
}

