/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.framework.puur;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.AvayaUninstallPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreUtil {
    public static void restore(List<Pack> selectedPacks, AbstractUIProgressHandler progressHandler) throws Exception {
        String zipFileName = null;
        ZipInputStream zipinputstream = null;
        ZipEntry zipentry = null;
        FileOutputStream fileoutputstream = null;
        File newFile = null;
        String entryName = null;
        String filename = null;
        String directory = null;
        for (Pack pack : selectedPacks) {
            zipFileName = AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), null) + File.separator + "backup.zip";
            if (zipFileName == null || !new File(zipFileName).exists()) continue;
            byte[] buf = new byte[1024];
            int totalCount = 0;
            zipinputstream = new ZipInputStream(new FileInputStream(zipFileName));
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                ++totalCount;
                zipinputstream.closeEntry();
            }
            zipinputstream.close();
            zipinputstream = new ZipInputStream(new FileInputStream(zipFileName));
            zipentry = zipinputstream.getNextEntry();
            int count = 0;
            while (zipentry != null) {
                int n;
                entryName = zipentry.getName();
                newFile = new File(entryName);
                if (entryName.lastIndexOf(File.separator) > -1) {
                    filename = entryName.substring(0, entryName.lastIndexOf(File.separator));
                    new File(filename).mkdirs();
                }
                newFile.createNewFile();
                if (progressHandler != null && progressHandler instanceof AvayaUninstallPanel) {
                    ((AvayaUninstallPanel)progressHandler).fileRestoreProgress(++count, totalCount, newFile.getAbsolutePath());
                }
                if ((directory = newFile.getParent()) == null && newFile.isDirectory()) break;
                fileoutputstream = new FileOutputStream(newFile, false);
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    fileoutputstream.write(buf, 0, n);
                    fileoutputstream.flush();
                }
                fileoutputstream.close();
                zipinputstream.closeEntry();
                Debug.log("Successfully restored " + entryName + ".");
                zipentry = zipinputstream.getNextEntry();
            }
            zipinputstream.close();
        }
        if (new File(zipFileName).exists()) {
            new File(zipFileName).delete();
        }
    }
}

