/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.framework.puur;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.IInventoryUtil;
import com.avaya.panther.inventory.InventoryUtil;
import com.avaya.panther.inventory.beans.Version;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.util.ArrayList;

public class PatchUpdateValidator {
    public boolean isNonPatchValid(AutomatedInstallData idata) {
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack pack : idata.availablePacks) {
            packs.add(pack);
        }
        for (Pack pack : packs) {
            String curr_version = pack.getVersion();
            Version version = new Version(curr_version);
            String versionString = version.toString();
            int lastDigit = Integer.parseInt(versionString.substring(versionString.lastIndexOf(".") + 1, versionString.length()));
            if (lastDigit == 0) continue;
            Debug.error("Can not combine a patch in Update/Upgrade installer: " + pack.getName() + "-" + pack.getVersion() + ", installation can not continue");
            idata.avayaAvailablePacks.clear();
            return false;
        }
        return !idata.avayaAvailablePacks.isEmpty();
    }

    public boolean isPatchValid(AutomatedInstallData idata) {
        return !idata.info.isCumulative() ? this.isNonCumulativePatchValid(idata) : this.isCumulativePatchValid(idata);
    }

    private boolean isNonCumulativePatchValid(AutomatedInstallData idata) {
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack pack : idata.availablePacks) {
            packs.add(pack);
        }
        for (Pack pack : packs) {
            String curr_version = pack.getVersion();
            int lastDigit = Integer.parseInt((curr_version = new Version(curr_version).toString()).substring(curr_version.lastIndexOf(".") + 1, curr_version.length()));
            if (lastDigit == 0) {
                Debug.error("Install Type[Patch] and Version[" + curr_version + "] Mismatch, hence removing it from available pack list");
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            String current = null;
            String previous = null;
            String prev_version = "";
            IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
            Version objPrevVersion = inventoryUtil.getLastInstalledVersion(pack.id, false);
            if (objPrevVersion != null) {
                prev_version = objPrevVersion.toString();
            }
            if (prev_version.equals("") && AvayaInstallerBase.getVersionType(curr_version).equals("PATCH")) {
                Debug.log("There is no previous version installed for pack-" + pack.name + ", hence removing it from available pack list.");
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            if (curr_version != null && !curr_version.equals("")) {
                current = curr_version.substring(0, curr_version.lastIndexOf("."));
            }
            if (prev_version != null && !prev_version.equals("")) {
                previous = prev_version.substring(0, curr_version.lastIndexOf("."));
            }
            if (inventoryUtil.versionExists(pack.id, new Version(curr_version))) {
                idata.avayaAvailablePacks.remove(pack);
            }
            if (current != null && previous != null && current.equals(previous)) {
                for (String version : pack.getRequiredVersions()) {
                    if (inventoryUtil.versionExists(pack.id, new Version(version))) continue;
                    Debug.log("Required version for pack-" + pack.name + " is missing, hence removing it from available pack list.");
                    idata.avayaAvailablePacks.remove(pack);
                }
                continue;
            }
            Debug.log("Patch version is incompitible with installed version for pack-" + pack.name + " is missing, hence removing it from available pack list.");
            idata.avayaAvailablePacks.remove(pack);
        }
        return !idata.avayaAvailablePacks.isEmpty();
    }

    private boolean isCumulativePatchValid(AutomatedInstallData idata) {
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack pack : idata.availablePacks) {
            packs.add(pack);
        }
        for (Pack pack : packs) {
            String curr_version = pack.getVersion();
            int lastDigit = Integer.parseInt((curr_version = new Version(curr_version).toString()).substring(curr_version.lastIndexOf(".") + 1, curr_version.length()));
            if (lastDigit == 0) {
                Debug.error("Install Type[Patch] and Version[" + curr_version + "] Mismatch, hence removing it from available pack list");
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            String current = null;
            String previous = null;
            String prev_version = "";
            IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
            Version objPrevVersion = inventoryUtil.getLastInstalledVersion(pack.id, false);
            if (objPrevVersion != null) {
                prev_version = objPrevVersion.toString();
            }
            if (prev_version.equals("") && AvayaInstallerBase.getVersionType(curr_version).equals("PATCH")) {
                Debug.error("A patch version(" + pack.name + ") found along with update installation.");
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            if (curr_version != null && !curr_version.equals("")) {
                current = curr_version.substring(0, curr_version.lastIndexOf("."));
            }
            if (!prev_version.equals("")) {
                previous = prev_version.substring(0, prev_version.lastIndexOf("."));
            }
            if (current != null && previous != null && current.equals(previous)) {
                int prev;
                int cur = Integer.parseInt(curr_version.substring(curr_version.lastIndexOf(".") + 1, curr_version.length()));
                if (cur > (prev = Integer.parseInt(prev_version.substring(prev_version.lastIndexOf(".") + 1, prev_version.length())))) continue;
                Debug.log("Update/Upgrade for " + pack.name + " cannot be applied as patch with higher version  is already applied!");
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            Debug.log("Patch(" + pack.name + ") cannot be applied as the current patch version is not compatible with the previous installed version!");
            idata.avayaAvailablePacks.remove(pack);
        }
        return !idata.avayaAvailablePacks.isEmpty();
    }

    public boolean isUpdateUpgradeValid(AutomatedInstallData idata) {
        ArrayList<Pack> packs = new ArrayList<Pack>();
        for (Pack pack : idata.availablePacks) {
            packs.add(pack);
        }
        for (Pack pack : packs) {
            String curr_version = pack.getVersion();
            String prev_version = "";
            IInventoryUtil inventoryUtil = InventoryUtil.getInventory();
            Version objPrevVersion = inventoryUtil.getLastInstalledVersion(pack.id, true);
            if (objPrevVersion != null) {
                prev_version = objPrevVersion.toString();
            }
            String installType = AvayaInstallerBase.getVersionType(curr_version);
            if (prev_version.equals("")) continue;
            if (installType.equals("PATCH")) {
                Debug.error("Found a patch, cannot apply Version for pack " + pack.getName() + "-" + pack.getVersion());
                idata.avayaAvailablePacks.remove(pack);
                continue;
            }
            if (!installType.equals("NON-PATCH")) continue;
            Version newVersion = new Version(curr_version);
            Version oldVersion = new Version(prev_version);
            int result = newVersion.compareTo(oldVersion);
            if (result > 0) {
                idata.setVariable(pack.id + "_INSTALLTYPE", "update");
                Debug.log(pack.id + " is an update installation.");
                continue;
            }
            Debug.log("A newer version is already installed for pack-" + pack.name + ", hence removing it from available pack list.");
            idata.avayaAvailablePacks.remove(pack);
        }
        return !idata.avayaAvailablePacks.isEmpty();
    }
}

