/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.framework.puur;

import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.inventory.InventoryUtil;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigParamFileHandler {
    private Properties properties = null;

    public static void loadConfigParamFile(AutomatedInstallData installData) throws Exception {
        String installPath = InventoryUtil.getInventory().getInstallPath();
        if (installPath == null || installPath.equals("")) {
            return;
        }
        String filepath = installPath + File.separator + "installdata" + File.separator;
        File confFile = new File(filepath = filepath + ".confParam");
        if (confFile.exists()) {
            AvayaInstallerBase.loadCustomVariables(installData, filepath);
        }
    }

    public Properties setConfParamProperties(AutomatedInstallData installData) {
        Properties allVariables = installData.getVariables();
        String allPasswordField = "";
        if (installData.getVariable("ALL_PASSWD_FIELDS") != null) {
            StringTokenizer pwdFieldTokenizer = new StringTokenizer(installData.getVariable("ALL_PASSWD_FIELDS"), ",");
            while (pwdFieldTokenizer.hasMoreTokens()) {
                allPasswordField = allPasswordField + pwdFieldTokenizer.nextToken().trim() + ",";
            }
        }
        Enumeration<Object> keyEnumerator = allVariables.keys();
        this.properties = new Properties();
        while (keyEnumerator.hasMoreElements()) {
            String currKey = (String)keyEnumerator.nextElement();
            if (currKey.startsWith("SYSTEM_")) continue;
            if (allPasswordField.indexOf(currKey + ",") < 0) {
                this.properties.setProperty(currKey, installData.getVariable(currKey));
                continue;
            }
            this.properties.setProperty(currKey, "");
        }
        return this.properties;
    }

    public void writeConfigParamFile(Pack pack, AutomatedInstallData installData) {
        if (this.properties == null) {
            return;
        }
        String path = AvayaInstallerBase.generatePackMetadataPath(pack.id, pack.getVersion(), installData.getInstallPath());
        try {
            new File(path).mkdirs();
            String confParamFilePath = path + File.separator + ".confParam";
            FileOutputStream confParamFO = new FileOutputStream(confParamFilePath);
            this.properties.store(confParamFO, "Config Param File");
            confParamFO.close();
        }
        catch (FileNotFoundException fio) {
            Debug.error("File creation failed, Unable to write into .confParam File for Pack " + pack.id);
        }
        catch (IOException io) {
            Debug.error("IO error occurred while writting into .confParam file for Pack " + pack.id);
        }
    }
}

