/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.framework.pantherinstaller;

import com.avaya.mgmt.trust.tmclient.service.TMServiceQuery;
import com.avaya.mgmt.trust.tmclient.service.TMServiceQueryFactory;
import com.avaya.panther.installer.AvayaInstallerBase;
import com.avaya.panther.util.FileModifier;
import com.avaya.panther.util.IExecutableClass;
import com.avaya.spirit.security.helper.SpiritSecurityHelper;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class TMSpiritSecurityHelper
implements IExecutableClass {
    public int execute(String[] args) {
        TMServiceQueryFactory queryFactory = new TMServiceQueryFactory();
        String serviceName = "spirit";
        AutomatedInstallData iData = AutomatedInstallData.getInstance();
        try {
            String tmConfigurationLocation = null;
            tmConfigurationLocation = iData.getVariable("TM_CONFIG_LOC") != null && !iData.getVariable("TM_CONFIG_LOC").equals("") ? iData.getVariable("TM_CONFIG_LOC") : iData.getVariable("JBOSS_CONF_DIR") + File.separator + "tm";
            TMServiceQuery serviceQuery = queryFactory.getTMServiceQuery(serviceName, tmConfigurationLocation);
            String keyAlias = serviceQuery.getKeyAlias();
            String keyPwd = serviceQuery.getKeyPassword();
            String keystorePath = serviceQuery.getKeyStorePath();
            String keyStorePwd = serviceQuery.getKeyStorePassword();
            String keyStoreType = serviceQuery.getKeyStoreType();
            String trustStorePath = serviceQuery.getTrustStorePath();
            String trustStorePwd = serviceQuery.getTrustStorePassword();
            String trustStoreType = serviceQuery.getTrustStoreType();
            if (Debug.isSTACKTRACE()) {
                Debug.trace("KeyAlias is:" + keyAlias);
                Debug.trace("key password is:" + keyPwd);
                Debug.trace("key store absolute path is:" + keystorePath);
                Debug.trace("key store password is:" + keyStorePwd);
                Debug.trace("key store type is:" + keyStoreType);
                Debug.trace("trust store absolute path is:" + trustStorePath);
                Debug.trace("trust store password is:" + trustStorePwd);
                Debug.trace("trust store type is:" + trustStoreType);
            }
            try {
                String jbossBinPath;
                String filePath = iData.getVariable("JBOSS_SERVER_DIR") + File.separator + "run.conf";
                if (new File(filePath).exists()) {
                    FileModifier.replaceAll(filePath, "Avaya123", trustStorePwd);
                }
                if (new File(filePath = (jbossBinPath = iData.getVariable("JBOSSDIR") + File.separator + "bin" + File.separator) + "shutdown.sh").exists()) {
                    FileModifier.replaceAll(filePath, "Avaya123", trustStorePwd);
                }
            }
            catch (Throwable tx) {
                Debug.log("Failed to update JBoss with truststore information.");
            }
            String spiritKeyStorePath = iData.getVariable("SPIRIT_AGENT_CONFIG_SECURITY");
            AvayaInstallerBase.addURLToClasspath(new File(spiritKeyStorePath).toURL());
            try {
                SpiritSecurityHelper.encryptPasswordForIdentityKeyStore((String)keyStorePwd, (String)spiritKeyStorePath);
            }
            catch (Throwable e) {
                Debug.log("SpiritSecurityHelper.encryptPasswordForIdentityKeyStore :: " + e.toString());
                e.printStackTrace();
            }
            String spiritPropertiesPath = iData.getVariable("SPIRIT_AGENT_CONFIG_SECURITY");
            spiritPropertiesPath = spiritPropertiesPath + File.separator + "spirit_security.properties";
            Properties prop = new Properties();
            if (new File(spiritPropertiesPath).exists()) {
                prop.load(new FileInputStream(spiritPropertiesPath));
                prop.setProperty("com.avaya.spirit.security.identityKeyStore", keystorePath);
                prop.store(new FileOutputStream(spiritPropertiesPath), "Installer::Spirit Security Information");
                if (Debug.isSTACKTRACE()) {
                    Debug.trace(spiritPropertiesPath + " population done.");
                }
            }
            String filePath = iData.getVariable("SPIRIT_AGENT_SCRIPTS") + File.separator + "configureSpiritSecurity.sh";
            FileModifier.replaceAll(filePath, "PAN_TRUST_PWD", trustStorePwd);
            FileModifier.replaceAll(filePath, "PAN_KEYSTORE_PWD", keyStorePwd);
        }
        catch (Throwable e) {
            Debug.log("TMSpiritSecurityHelper :: " + e.toString());
            e.printStackTrace();
            return -1;
        }
        return 0;
    }
}

