/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.framework.pantherinstaller;

import com.avaya.panther.framework.pantherinstaller.ProtectedPropertiesDecorator;
import com.izforge.izpack.Pack;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.util.Properties;

public class PantherInstallerListener
extends SimpleInstallerListener {
    public void beforeInstallation(AutomatedInstallData idata) {
        try {
            String hostname = Inet4Address.getLocalHost().getHostName();
            idata.setVariable("SPIRIT.platformqualifier", "Enterprise-" + hostname);
            idata.setVariable("SPIRIT.platformName", "Enterprise-" + hostname);
            idata.setVariable("local_host_fqdn", Inet4Address.getLocalHost().getCanonicalHostName());
            idata.setVariable("SPIRIT.url.1", Inet4Address.getLocalHost().getCanonicalHostName());
            String ipAddress = Inet4Address.getLocalHost().getHostAddress();
            String udpGroupAddress = "230" + ipAddress.substring(ipAddress.indexOf("."));
            if (idata.getVariable("jboss.partition.udpGroup") == null) {
                idata.setVariable("jboss.partition.udpGroup", udpGroupAddress);
            }
        }
        catch (Exception e) {
            Debug.error(e.toString());
        }
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        Properties properties = ProtectedPropertiesDecorator.getInstance(AutomatedInstallData.getInstance().getVariables());
        String encryptionUtilsClassName = "com.avaya.coreservice.um.domain.helpers.EncryptionUtils";
        Class<?> encryptionUtilsClass = Class.forName(encryptionUtilsClassName);
        Method encryptUpmVariablesMethod = encryptionUtilsClass.getMethod("encryptUpmVariables", Properties.class);
        encryptUpmVariablesMethod.invoke(null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String installFilePath = idata.getVariable("PANTHER_INSTALL_PATH");
        String versionFileName = "installer_relno.txt";
        if (installFilePath != null) {
            BufferedReader reader = null;
            String versionLine = null;
            File versionFile = new File(installFilePath + "/" + versionFileName);
            if (versionFile.exists()) {
                try {
                    reader = new BufferedReader(new FileReader(versionFile));
                    versionLine = reader.readLine();
                    if (versionLine == null) return;
                    idata.setVariable("avaya.mgmt.installversion", versionLine.trim());
                    return;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            } else {
                Debug.trace("File does not exist at " + installFilePath);
            }
            return;
        } else {
            Debug.trace("Problem in Install Path : " + installFilePath);
        }
    }
}

