/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.panther.compiler;

import com.avaya.panther.compiler.ModifyListeners;
import com.avaya.panther.compiler.ModifyResources;
import com.izforge.izpack.compiler.CompilerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class PreCompiler {
    public static final String IZPACK_VERSION = "3.11.0";
    private String filename;
    private String basedir;
    private XMLElement data;
    private String installText;
    public static final String VERSION = "1.0";
    int exitCode = 1;
    File base;

    public PreCompiler(String filename, String basedir) throws CompilerException {
        this.filename = filename;
        this.basedir = basedir;
    }

    public String process() throws Exception {
        this.base = new File(this.basedir).getAbsoluteFile();
        if (!this.base.canRead() || !this.base.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + this.base);
        }
        this.getXMLTree();
        this.modifyInstallXML(this.data);
        return this.generateNewInstallXML();
    }

    private void modifyInstallXML(XMLElement data) throws InterruptedException, IOException {
        ModifyResources mdRes = new ModifyResources(data, this.base);
        mdRes.getModifiedResourceElement();
        ModifyListeners modifyListeners = new ModifyListeners(data, this.base);
        modifyListeners.getModifiedListenerElement();
    }

    private String generateNewInstallXML() {
        File outputInstallXML = new File(this.basedir, "temp_install.xml");
        outputInstallXML.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputInstallXML);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        XMLWriter writer = new XMLWriter(out);
        try {
            writer.write(this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputInstallXML.toString();
    }

    protected void getXMLTree() throws CompilerException, IOException {
        IXMLReader reader = null;
        if (this.filename != null) {
            File file = new File(this.filename).getAbsoluteFile();
            if (!file.canRead()) {
                throw new CompilerException("Invalid file: " + file);
            }
            reader = new StdXMLReader(new FileInputStream(this.filename));
        } else if (this.installText != null) {
            reader = StdXMLReader.stringReader(this.installText);
        } else {
            throw new CompilerException("Neither install file nor text specified");
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setReader(reader);
        parser.setValidator(new NonValidator());
        try {
            this.data = (XMLElement)parser.parse();
        }
        catch (Exception x) {
            throw new CompilerException("Error parsing installation file", (Throwable)x);
        }
        if (!"installation".equalsIgnoreCase(this.data.getName())) {
            this.parseError(this.data, "this is not an IzPack XML installation file");
        }
    }

    protected void parseError(XMLElement parent, String message) throws CompilerException {
        throw new CompilerException(this.filename + ":" + parent.getLineNr() + ": " + message);
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public XMLElement getData() {
        return this.data;
    }

    public void setData(XMLElement data) {
        this.data = data;
    }
}

