/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.PluginResource;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;

public class EventCode {
    protected static final String rbName = "EventCodes";
    protected String mCode = null;
    protected String mNameSpace = null;
    protected Priority mLogLevel = LogLevel.FINEST;

    public EventCode(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("A null Message Code argument is invalid.");
        }
        if (string2 == null) {
            throw new NullPointerException("A null NameSpace argument is invalid.");
        }
        if (string.length() > 32) {
            throw new IllegalArgumentException("The maximum Message Code size is 32 characters.");
        }
        this.mLogLevel = LogLevel.FINEST;
        this.mCode = string;
        this.mNameSpace = string2;
    }

    public EventCode(String string, String string2, Priority priority) {
        if (string == null) {
            throw new NullPointerException("A null Message Code argument is invalid.");
        }
        if (string2 == null) {
            throw new NullPointerException("A null NameSpace argument is invalid.");
        }
        if (string.length() > 32) {
            throw new IllegalArgumentException("The maximum Message Code size is 32 characters.");
        }
        this.mLogLevel = priority == null ? LogLevel.FINEST : priority;
        this.mCode = string;
        this.mNameSpace = string2;
    }

    public Priority getLogLevel() {
        return this.mLogLevel;
    }

    public void setLogLevel(Level level) {
        this.mLogLevel = level;
    }

    public String getCode() {
        return this.mCode;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EventCode)) {
            return false;
        }
        EventCode eventCode = (EventCode)object;
        return eventCode.mCode.equals(this.mCode) && eventCode.mLogLevel.equals(this.mLogLevel) && eventCode.mNameSpace.equals(this.mNameSpace);
    }

    protected String getEventMsgString() throws Exception {
        String string = this.mNameSpace + "." + rbName;
        String string2 = "";
        ResourceBundle resourceBundle = null;
        try {
            FileInputStream fileInputStream;
            block5: {
                fileInputStream = null;
                try {
                    resourceBundle = ResourceBundle.getBundle(string);
                }
                catch (MissingResourceException missingResourceException) {
                    PluginResource pluginResource = new PluginResource();
                    fileInputStream = pluginResource.getPropertiesFile(Locale.getDefault().toString(), this.mNameSpace);
                    if (fileInputStream == null) break block5;
                    resourceBundle = new PropertyResourceBundle(fileInputStream);
                }
            }
            string2 = resourceBundle.getString(this.mCode);
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            LogLog.error("Cannot find message for EventCode=" + this.mCode);
            throw new Exception("Cannot find message for EventCode=" + this.mCode);
        }
        return string2;
    }

    public String toString() {
        return this.mCode;
    }
}

