/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.helper.EventMsg;
import com.avaya.common.logging.helper.LogRecordJDO;
import com.avaya.common.logging.helper.ParameterCoder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class StandardFormatter
extends Layout {
    private static final int FACILITY_DEFAULT = 1;
    private static final int SEVERITY_DEFAULT = 7;
    private static final int PRI_DEFAULT = 15;
    private static final int MAX_FACILITY = 23;
    private static final int MIN_FACILITY = 0;
    private static final int MAX_SEVERITY = 7;
    private static final int MIN_SEVERITY = 0;
    private static final int MAX_MESSAGE_LENGTH = 2000;
    private static final int MAX_MILLIS_LENGTH = 3;
    private static final String HOSTNAME_DEFAULT = "noHostName";
    private static final String LOG_FORMAT_DEFAULT = "1";
    private static final String PROCESS_NAME_DEFAULT = "noProcessName";
    private static final String PROCESS_ID_DEFAULT = null;
    private static final String UTC_OFFSET_DEFAULT = "-NoSet";
    private static final String YEAR_DEFAULT = "0000";
    private static final String MILLIS_DEFAULT = "000";
    private static final String LOG_PRODUCT_TYPE_DEFAULT = "noProductType";
    private static final String EVENT_ID_DEFAULT = "";
    private static final String EMPTY_STRING = "";
    private static final String SEPARATOR = " ";
    private static final String MARKER = "|";
    private boolean throwable = false;
    private boolean localize = false;
    private boolean displayPath = false;
    private int facility = 1;
    private String jdoOverwrite = null;

    public synchronized String format(LoggingEvent loggingEvent) {
        String string;
        int n = 7;
        int n2 = 15;
        String string2 = "";
        String string3 = HOSTNAME_DEFAULT;
        String string4 = PROCESS_NAME_DEFAULT;
        String string5 = PROCESS_ID_DEFAULT;
        String string6 = UTC_OFFSET_DEFAULT;
        String string7 = YEAR_DEFAULT;
        String string8 = MILLIS_DEFAULT;
        String string9 = LOG_PRODUCT_TYPE_DEFAULT;
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        LogRecordJDO.Database database = LogRecordJDO.Database.NONE;
        String string14 = PROCESS_NAME_DEFAULT;
        String string15 = "";
        String string16 = "";
        String string17 = loggingEvent.getLocationInformation().getClassName();
        String string18 = "LOG_STORE";
        int n3 = 0;
        String[] stringArray = loggingEvent.getThrowableStrRep();
        boolean bl = false;
        string10 = LOG_FORMAT_DEFAULT;
        Date date = new Date();
        String string19 = null;
        String string20 = null;
        String string21 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(date.toString(), SEPARATOR);
        int n4 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string22 = stringTokenizer.nextToken();
            switch (++n4) {
                case 2: {
                    string19 = string22;
                    break;
                }
                case 3: {
                    if (string22.charAt(0) == '0') {
                        string20 = SEPARATOR + string22.charAt(1);
                        break;
                    }
                    string20 = string22;
                    break;
                }
                case 4: {
                    string21 = string22;
                    break;
                }
                case 6: {
                    string7 = string22;
                }
            }
        }
        string2 = string19 + SEPARATOR + string20 + SEPARATOR + string21;
        long l = date.getTime();
        string8 = this.getMillis(l);
        LogRecordJDO logRecordJDO = null;
        if (this.jdoOverwrite != null) {
            try {
                logRecordJDO = (LogRecordJDO)Class.forName(this.jdoOverwrite).newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        LogRecordJDO logRecordJDO2 = null;
        Object object = loggingEvent.getMessage();
        if (object instanceof LogRecordJDO) {
            logRecordJDO2 = (LogRecordJDO)object;
        }
        if (logRecordJDO != null) {
            if (logRecordJDO2 != null) {
                logRecordJDO.setLogMessage(logRecordJDO2.getLogMessage());
                logRecordJDO.setSeverity(logRecordJDO2.getSeverity());
            }
            logRecordJDO2 = logRecordJDO;
        }
        try {
            bl = Class.forName("com.avaya.coreservice.logging.CodedMsg").isInstance(object);
            if (bl) {
                if (logRecordJDO == null) {
                    logRecordJDO2 = new LogRecordJDO();
                }
                logRecordJDO2.setLogMessage(object);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (logRecordJDO2 != null) {
            n = logRecordJDO2.getSeverity();
            if (n > 7 || n < 0) {
                n = 7;
            }
            n2 = 8 * this.facility + n;
            string3 = this.removeWhiteSpace(logRecordJDO2.getHostname());
            if (!this.validateHostname(string3)) {
                string3 = HOSTNAME_DEFAULT;
            }
            if (!this.validateProcessName(string4 = this.truncateAtNonAlphaCharacter(logRecordJDO2.getProcessName()))) {
                string4 = PROCESS_NAME_DEFAULT;
            }
            if (!this.validateProcessID(string5 = this.removeWhiteSpace(logRecordJDO2.getProcessId()))) {
                string5 = null;
            }
            string14 = string5 == null ? string4 : string4 + "[" + string5 + "]";
            TimeZone timeZone = logRecordJDO2.getTimeZone();
            string6 = this.convertTimeZoneToUtcOffset(timeZone);
            if (string6 == null || string6.length() == 0) {
                string6 = UTC_OFFSET_DEFAULT;
            }
            string9 = this.updateLogProductType(logRecordJDO2.getLogProductType(), string17);
            Object object2 = logRecordJDO2.getLogMessage();
            if (object2 instanceof EventMsg) {
                if (object2 != null) {
                    string11 = ((EventMsg)object2).getEventCode().getCode();
                    string15 = ((EventMsg)object2).getEventCode().getNameSpace();
                    if (this.localize) {
                        n3 = 1;
                        string12 = ((EventMsg)object2).getDecodedMsg();
                    } else {
                        n3 = 2;
                        string12 = ((EventMsg)object2).getParameterMsg();
                    }
                    string16 = n3 + SEPARATOR + string15 + SEPARATOR + string11;
                } else {
                    n3 = 0;
                    string12 = "";
                    string16 = n3 + "";
                    LogLog.debug("null EventMsg object was recieved by StandardFormatter");
                    if (this.displayPath) {
                        string12 = string17 + SEPARATOR + string12;
                    }
                }
            } else if (object2 instanceof String) {
                n3 = 0;
                string16 = n3 + "";
                string12 = object2.toString();
                if (this.displayPath) {
                    string12 = string17 + SEPARATOR + string12;
                }
            } else if (bl) {
                if (object2 != null) {
                    try {
                        Method method;
                        Class<?> clazz = Class.forName("com.avaya.coreservice.logging.CodedMsg");
                        Class<?> clazz2 = Class.forName("com.avaya.coreservice.logging.MsgCode");
                        Method method2 = clazz.getMethod("getMsgCode", new Class[0]);
                        Method method3 = clazz2.getMethod("getCode", new Class[0]);
                        Method method4 = clazz2.getMethod("getResourceBundleName", new Class[0]);
                        Object object3 = method2.invoke(object2, new Object[0]);
                        string11 = (String)method3.invoke(object3, new Object[0]);
                        string15 = (String)method4.invoke(object3, new Object[0]);
                        string15 = string15.substring(0, string15.lastIndexOf(46));
                        if (this.localize) {
                            n3 = 1;
                            method = clazz.getMethod("getLocalizedMsg", Locale.class);
                            string12 = (String)method.invoke(object2, Locale.ENGLISH);
                        } else {
                            n3 = 2;
                            method = clazz.getMethod("getArguments", new Class[0]);
                            string12 = this.getParameterMsg((Object[])method.invoke(object2, new Object[0]));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    string16 = n3 + SEPARATOR + string15 + SEPARATOR + string11;
                } else {
                    n3 = 0;
                    string12 = "";
                    string16 = n3 + "";
                    LogLog.debug("null CodedMsg object was recieved by StandardFormatter");
                    if (this.displayPath) {
                        string12 = string17 + SEPARATOR + string12;
                    }
                }
            } else {
                n3 = 0;
                string12 = "";
                string16 = n3 + "";
                LogLog.debug("logMessage was unrecognizable in StandardFormatter");
                if (this.displayPath) {
                    string12 = string17 + SEPARATOR + string12;
                }
            }
            database = logRecordJDO2.getDatabaseType();
        } else {
            n2 = 8 * this.facility + n;
            n3 = 0;
            string12 = object != null ? object.toString() : "";
            string16 = n3 + "";
            LogLog.debug("messageObject was not a LogRecordJDO type in StandardFormatter");
            if (this.displayPath) {
                string12 = string17 + SEPARATOR + string12;
            }
        }
        if (this.throwable && stringArray != null) {
            string12 = string12 + ">";
            for (int i = 0; i < stringArray.length; ++i) {
                string12 = string12 + System.getProperty("line.separator") + "- " + stringArray[i];
            }
            string12 = string12 + System.getProperty("line.separator") + "=== End of Stack Trace ===";
        }
        try {
            string12 = string = new String(string12.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogLog.debug("Log Message could not be converted to UTF-8 in StandardFormatter");
        }
        if (database == LogRecordJDO.Database.NONE) {
            string13 = "<" + n2 + ">" + string2 + SEPARATOR + string3 + SEPARATOR + string14 + ":" + SEPARATOR + string6 + SEPARATOR + string7 + SEPARATOR + string8 + SEPARATOR + string10 + SEPARATOR + string9 + SEPARATOR + MARKER + SEPARATOR + string16 + SEPARATOR + string12;
            return string13 + System.getProperty("line.separator");
        }
        if (database == LogRecordJDO.Database.ORACLE) {
            string = "";
            if (string12.length() > 2000) {
                string12 = string12.substring(0, 2000);
            }
            string = "insert into " + string18 + " (PRIORITY_NUM, FACILITY_NUM, PRIORITY_FACILITY_NUM, LOG_TIMESTAMP_NUM, HOST_NAME, PROCESS_NAME, " + "UTC_OFFSET_DESC, LOG_YEAR_NUM, LOG_MILLISECOND_TEXT, LOG_FORMAT_DESC, PRODUCT_LOG_TEXT," + " MESSAGE_FORMAT_IND, LOCAL_NAME_SPACE_TEXT, EVENT_MESSAGE_CODE, " + " LOG_MESSAGE_TEXT, ENGLISH_MESSAGE_TEXT) values(" + n + "," + this.facility + "," + n2 + ", " + l + ", " + "'" + string3 + "', " + "'" + string14 + "', " + "'" + string6 + "', " + Integer.parseInt(string7) + ", " + "'" + string8 + "', " + "'" + string10 + "', " + "'" + string9 + "', " + n3 + ", " + "'" + string15 + "', " + "'" + string11 + "', " + "'" + string12 + "', " + "'" + string12 + "')";
            return string;
        }
        if (database == LogRecordJDO.Database.POSTGRES) {
            string = "";
            if (string12.length() > 2000) {
                string12 = string12.substring(0, 2000);
            }
            string = "insert into " + string18 + " (priority_num, facility_num, priority_facility_num, log_timestamp_num, host_name, process_name, " + "utc_offset_desc, log_year_num, log_millisecond_text, log_format_desc, product_log_text," + " message_format_ind, local_name_space_text, event_message_code, " + " log_message_text, english_message_text ) values(" + n + "," + this.facility + ", " + n2 + ", " + l + ", " + "'" + string3 + "', " + "'" + string14 + "', " + "'" + string6 + "', " + Integer.parseInt(string7) + ", " + "'" + string8 + "', " + "'" + string10 + "', " + "'" + string9 + "', " + n3 + ", " + "'" + string15 + "', " + "'" + string11 + "', " + "'" + string12 + "', " + "'" + string12 + "')";
            return string;
        }
        return null;
    }

    public void activateOptions() {
        LogLog.debug("FileLayout.activateOptions()");
    }

    public boolean ignoresThrowable() {
        return false;
    }

    private String getMillis(long l) {
        String string = new Long(l).toString();
        int n = string.length();
        string = string.substring(n - 3, n);
        return string;
    }

    private String convertTimeZoneToUtcOffset(TimeZone timeZone) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (timeZone == null) {
            return null;
        }
        int n = timeZone.getRawOffset() / 1000;
        if (n < 0) {
            string = "-";
            n *= -1;
        } else {
            string = "+";
        }
        int n2 = n / 3600;
        string2 = new Integer(n2).toString();
        int n3 = (n - n2 * 3600) / 60;
        string3 = new Integer(n3).toString();
        if (n2 < 10) {
            string2 = "0" + string2;
        }
        if (n3 < 10) {
            string3 = "0" + string3;
        }
        return string + string2 + ":" + string3;
    }

    private String removeWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(' ', '_');
    }

    private String truncateAtNonAlphaCharacter(String string) {
        char c;
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && ((c = string.charAt(n)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9'); ++n) {
        }
        return string.substring(0, n);
    }

    private boolean validateHostname(String string) {
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    private boolean validateProcessName(String string) {
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    private boolean validateProcessID(String string) {
        if (string == null) {
            return false;
        }
        return string.length() != 0;
    }

    private String updateLogProductType(String string, String string2) {
        if ((string = this.removeWhiteSpace(string)) == null || string.length() == 0 || string.indexOf(".") == -1) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        for (int i = n + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') continue;
            return string2;
        }
        if (string.charAt(0) == '.') {
            string = "com.avaya" + string;
        }
        return string;
    }

    public static String getExceptionString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public void setThrowable(boolean bl) {
        this.throwable = bl;
    }

    public boolean getThrowable() {
        return this.throwable;
    }

    public void setLocalizedMessage(boolean bl) {
        this.localize = bl;
    }

    public boolean getLocalizedMessage() {
        return this.localize;
    }

    public void setJdoOverwrite(String string) {
        this.jdoOverwrite = string;
    }

    public String getJdoOverwrite() {
        return this.jdoOverwrite;
    }

    public void setFacility(int n) {
        if (n > 23 || n < 0) {
            n = 1;
        }
        this.facility = n;
    }

    public int getFacility() {
        return this.facility;
    }

    public void setDisplayPathOnDebug(boolean bl) {
        this.displayPath = bl;
    }

    public boolean getDisplayPathOnDebug() {
        return this.displayPath;
    }

    public String getParameterMsg(Object[] objectArray) {
        return ParameterCoder.decodeParameters(objectArray);
    }
}

