/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.CommonLoggingLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class FallbackErrorHandler
implements ErrorHandler {
    private final String ERROR_PREFIX = "log4j error: ";
    Appender backupAppender;
    Appender primaryAppender;
    List<Logger> loggers;
    boolean firstTime = true;
    private PrintStream errorFilePrintStream = System.err;
    private String fileName;

    public void setLogger(Logger logger) {
        if (this.loggers == null) {
            this.loggers = new ArrayList<Logger>();
        }
        this.loggers.add(logger);
    }

    public void setAppender(Appender appender) {
        this.primaryAppender = appender;
    }

    public void setBackupAppender(Appender appender) {
        this.backupAppender = appender;
    }

    public void error(String string) {
        this.error(string, null, 0, null);
    }

    public void error(String string, Exception exception, int n) {
        this.error(string, exception, n, null);
    }

    public void error(String string, Exception exception, int n, LoggingEvent loggingEvent) {
        if (this.firstTime) {
            this.setErrorFile();
            try {
                if (this.backupAppender == null) {
                    this.backupAppender = new RollingFileAppender(new CommonLoggingLayout(), this.fileName, true);
                    this.backupAppender.setName("default-fallback");
                }
            }
            catch (IOException iOException) {
                LogLog.error("Creating fallback file appender failed.", iOException);
            }
            this.errorFilePrintStream.println("log4j error: " + string);
            if (exception != null) {
                exception.printStackTrace(this.errorFilePrintStream);
            }
            this.errorFilePrintStream.println("FB: INITIATING FALLBACK PROCEDURE.");
            if (this.loggers != null) {
                for (int i = 0; i < this.loggers.size(); ++i) {
                    Logger logger = this.loggers.get(i);
                    this.errorFilePrintStream.println("FB: Searching for [" + this.primaryAppender.getName() + "] in logger [" + logger.getName() + "].");
                    this.errorFilePrintStream.println("FB: Replacing [" + this.primaryAppender.getName() + "] by [" + this.backupAppender.getName() + "] in logger [" + logger.getName() + "].");
                    logger.removeAppender(this.primaryAppender);
                    this.errorFilePrintStream.println("FB: Adding appender [" + this.backupAppender.getName() + "] to logger " + logger.getName());
                    logger.addAppender(this.backupAppender);
                }
            }
            this.errorFilePrintStream.flush();
            this.firstTime = false;
        }
    }

    private void setErrorFile() {
        Object object;
        String string = System.getenv("AVAYA_LOG");
        if (string != null) {
            object = string + System.getProperty("file.separator") + "mgmt" + System.getProperty("file.separator") + "logs" + System.getProperty("file.separator");
            this.fileName = (String)object + this.primaryAppender.getName().concat(".error.log");
        } else {
            this.fileName = this.primaryAppender.getName().concat(".error.log");
        }
        object = new File(this.fileName);
        try {
            if (!((File)object).exists()) {
                ((File)object).createNewFile();
            }
            this.errorFilePrintStream = new PrintStream(new FileOutputStream(this.fileName, true));
        }
        catch (IOException iOException) {
            LogLog.error("Creating " + this.fileName + " for the fallback appender failed.", iOException);
        }
    }

    public void activateOptions() {
    }
}

