/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.ClientPropertyWatch;
import com.avaya.common.logging.client.Logger;
import com.avaya.common.logging.helper.LogRecordJDO;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.TimeZone;

public class CommonLogManager {
    static HashMap<String, Logger> staticLoggerList = new HashMap();
    static ThreadLocalJDOList jdoHolder = new ThreadLocalJDOList();
    static HashMap<String, LogRecordJDO> staticJdoList = new HashMap();
    static Logger rootLogger = null;
    protected static ClientPropertyWatch propertyChecker = new ClientPropertyWatch();

    public static Logger getLogger(String string) {
        Logger logger = staticLoggerList.get(string);
        if (logger == null) {
            logger = new Logger(string);
            logger.setJDO(string);
            staticLoggerList.put(string, logger);
        }
        return logger;
    }

    public static void checkConfig() {
        propertyChecker.check();
    }

    public static Logger getLogger(String string, UID uID) {
        Logger logger = staticLoggerList.get(string + ":" + uID);
        if (logger == null) {
            logger = new Logger(string);
            logger.setJDO(uID.toString());
            staticLoggerList.put(string + ":" + uID, logger);
        }
        return logger;
    }

    public static Logger getRootLogger() {
        if (rootLogger == null) {
            rootLogger = new Logger();
            rootLogger.setJDO("rootLogger");
        }
        return rootLogger;
    }

    public static void initializeJDO(String string, String string2, String string3, String string4, TimeZone timeZone, String string5) {
        CommonLogManager.initializeLogRecordJDO(string, string2, string3, string4, timeZone, string5);
    }

    public static void initializeJDO(UID uID, String string, String string2, String string3, TimeZone timeZone, String string4) {
        CommonLogManager.initializeLogRecordJDO(uID.toString(), string, string2, string3, timeZone, string4);
    }

    private static void initializeLogRecordJDO(String string, String string2, String string3, String string4, TimeZone timeZone, String string5) {
        LogRecordJDO logRecordJDO = new LogRecordJDO();
        logRecordJDO.setHostname(string2);
        logRecordJDO.setProcessId(string3);
        logRecordJDO.setProcessName(string4);
        logRecordJDO.setTimeZone(timeZone);
        logRecordJDO.setLogProductType(string5);
        jdoHolder = new ThreadLocalJDOList();
        staticJdoList.put(string, logRecordJDO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LogRecordJDO getLogRecordJDO(String string) {
        LogRecordJDO logRecordJDO = jdoHolder.getList().get(string);
        LogRecordJDO logRecordJDO2 = null;
        HashMap<String, LogRecordJDO> hashMap = staticJdoList;
        synchronized (hashMap) {
            logRecordJDO2 = staticJdoList.get(string);
            if (logRecordJDO2 == null) {
                logRecordJDO2 = new LogRecordJDO();
                staticJdoList.put(string, logRecordJDO2);
            }
        }
        if (logRecordJDO == null) {
            logRecordJDO = logRecordJDO2.clone();
            jdoHolder.getList().put(string, logRecordJDO);
        }
        return logRecordJDO;
    }

    protected static void updateLogRecordJDO(String string, LogRecordJDO logRecordJDO) {
        jdoHolder = new ThreadLocalJDOList();
        staticJdoList.put(string, logRecordJDO);
    }

    protected static void updateInstanceLogRecordJDO(String string, LogRecordJDO logRecordJDO) {
        jdoHolder.getList().put(string, logRecordJDO);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThreadLocalJDOList
    extends ThreadLocal<HashMap<String, LogRecordJDO>> {
        ThreadLocalJDOList() {
        }

        @Override
        public HashMap<String, LogRecordJDO> initialValue() {
            return new HashMap<String, LogRecordJDO>();
        }

        public HashMap<String, LogRecordJDO> getList() {
            return (HashMap)super.get();
        }
    }
}

